/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractTextMovieUIFilter;

public class MovieCountryFilter
extends AbstractTextMovieUIFilter {
    @Override
    public String getId() {
        return "movieCountry";
    }

    @Override
    public boolean accept(Movie movie) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)movie.getCountry())) {
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(movie.getCountry()));
                return matcher.find();
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.country"));
    }
}

