/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieDifferentRuntimeFilter
extends AbstractMovieUIFilter {
    private JSpinner spinner;

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.runtimedifference"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.spinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        return this.spinner;
    }

    @Override
    public String getId() {
        return "movieDifferentRuntime";
    }

    @Override
    public String getFilterValueAsString() {
        return this.spinner.getValue().toString();
    }

    @Override
    public void setFilterValue(Object value) {
        try {
            this.spinner.setValue(Integer.parseInt(value.toString()));
        }
        catch (Exception e) {
            this.spinner.setValue(1);
        }
    }

    @Override
    public void clearFilter() {
        this.spinner.setValue(1);
    }

    @Override
    public boolean accept(Movie movie) {
        int mediaInfoRuntimeInMinutes;
        int scrapedRuntimeInMinutes = movie.getRuntime();
        return scrapedRuntimeInMinutes - (mediaInfoRuntimeInMinutes = movie.getRuntimeFromMediaFilesInMinutes()) >= (Integer)this.spinner.getValue() || mediaInfoRuntimeInMinutes - scrapedRuntimeInMinutes >= (Integer)this.spinner.getValue();
    }
}

