/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractTextMovieUIFilter;

public class MovieFilenameFilter
extends AbstractTextMovieUIFilter {
    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.filename"));
    }

    @Override
    public String getId() {
        return "movieFilename";
    }

    @Override
    public boolean accept(Movie movie) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            for (MediaFile mediaFile : movie.getMediaFiles()) {
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(mediaFile.getFilename()));
                if (!matcher.find()) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }
}

