/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.TmmLabel;

class MovieScraperNfoSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -299825914193235308L;
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener = e -> this.checkChanges();
    private final ItemListener comboBoxListener = e -> this.checkChanges();
    private JComboBox<MovieConnectors> cbNfoFormat;
    private JCheckBox cbMovieNfoFilename1;
    private JCheckBox cbMovieNfoFilename2;
    private JComboBox<CertificationStyleWrapper> cbCertificationStyle;
    private JCheckBox chckbxWriteCleanNfo;
    private JComboBox<MediaLanguages> cbNfoLanguage;
    private JComboBox<DateField> cbDatefield;
    private JHintCheckBox chckbxCreateOutline;
    private JCheckBox chckbxOutlineFirstSentence;
    private JCheckBox chckbxSingleStudio;
    private JCheckBox chckbxNfoDiscKodiStyle;
    private JHintCheckBox chckbxLockdata;

    MovieScraperNfoSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.cbNfoFormat.addItemListener(e -> {
            block2: {
                block3: {
                    if (this.cbNfoFormat.getSelectedItem() != MovieConnectors.MP) break block3;
                    for (int i = 0; i < this.cbCertificationStyle.getItemCount(); ++i) {
                        CertificationStyleWrapper wrapper = this.cbCertificationStyle.getItemAt(i);
                        if (wrapper.style != CertificationStyle.TECHNICAL) continue;
                        this.cbCertificationStyle.setSelectedItem(wrapper);
                        break block2;
                    }
                    break block2;
                }
                if (this.cbNfoFormat.getSelectedItem() != MovieConnectors.XBMC) break block2;
                for (int i = 0; i < this.cbCertificationStyle.getItemCount(); ++i) {
                    CertificationStyleWrapper wrapper = this.cbCertificationStyle.getItemAt(i);
                    if (wrapper.style != CertificationStyle.LARGE) continue;
                    this.cbCertificationStyle.setSelectedItem(wrapper);
                    break;
                }
            }
        });
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName()) || "wizard".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
                this.buildComboBoxes();
            }
        });
        this.buildCheckBoxes();
        this.buildComboBoxes();
    }

    private void buildCheckBoxes() {
        this.cbMovieNfoFilename1.removeItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename2.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.cbMovieNfoFilename1, this.cbMovieNfoFilename2);
        List<MovieNfoNaming> movieNfoFilenames = this.settings.getNfoFilenames();
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.FILENAME_NFO)) {
            this.cbMovieNfoFilename1.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.MOVIE_NFO)) {
            this.cbMovieNfoFilename2.setSelected(true);
        }
        this.cbMovieNfoFilename1.addItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename2.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    private void buildComboBoxes() {
        this.cbCertificationStyle.removeItemListener(this.comboBoxListener);
        this.cbCertificationStyle.removeAllItems();
        for (CertificationStyle style : CertificationStyle.values()) {
            CertificationStyleWrapper wrapper = new CertificationStyleWrapper();
            wrapper.style = style;
            this.cbCertificationStyle.addItem(wrapper);
            if (style != this.settings.getCertificationStyle()) continue;
            this.cbCertificationStyle.setSelectedItem(wrapper);
        }
        this.cbCertificationStyle.addItemListener(this.comboBoxListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[]"));
        JPanel panelNfo = new JPanel();
        panelNfo.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][][][][][][][]"));
        TmmLabel lblNfoT = new TmmLabel(TmmResourceBundle.getString("Settings.nfo"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelNfo, lblNfoT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#nfo-settings"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblNfoFormat = new JLabel(TmmResourceBundle.getString("Settings.nfoFormat"));
        panelNfo.add((Component)lblNfoFormat, "cell 1 0 2 1");
        this.cbNfoFormat = new JComboBox<MovieConnectors>(MovieConnectors.values());
        panelNfo.add(this.cbNfoFormat, "cell 1 0 2 1");
        DocsButton docsButton = new DocsButton("/movies/nfo-formats");
        panelNfo.add((Component)docsButton, "cell 1 0 2 1");
        JPanel panelNfoFormat = new JPanel();
        panelNfo.add((Component)panelNfoFormat, "cell 1 1 2 1");
        panelNfoFormat.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][]"));
        JLabel lblNfoFileNaming = new JLabel(TmmResourceBundle.getString("Settings.nofFileNaming"));
        panelNfoFormat.add((Component)lblNfoFileNaming, "cell 0 0");
        this.cbMovieNfoFilename1 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + ".nfo");
        panelNfoFormat.add((Component)this.cbMovieNfoFilename1, "cell 1 0");
        this.cbMovieNfoFilename2 = new JCheckBox("movie.nfo");
        panelNfoFormat.add((Component)this.cbMovieNfoFilename2, "cell 1 1");
        this.chckbxNfoDiscKodiStyle = new JCheckBox(TmmResourceBundle.getString("Settings.nfoDiscFolder"));
        panelNfo.add((Component)this.chckbxNfoDiscKodiStyle, "cell 2 2");
        this.chckbxWriteCleanNfo = new JCheckBox(TmmResourceBundle.getString("Settings.writecleannfo"));
        panelNfo.add((Component)this.chckbxWriteCleanNfo, "cell 1 3 2 1");
        JLabel lblNfoDatefield = new JLabel(TmmResourceBundle.getString("Settings.dateadded"));
        panelNfo.add((Component)lblNfoDatefield, "cell 1 5 2 1");
        this.cbDatefield = new JComboBox<DateField>(DateField.values());
        panelNfo.add(this.cbDatefield, "cell 1 5 2 1");
        JLabel lblNfoLanguage = new JLabel(TmmResourceBundle.getString("Settings.nfolanguage"));
        panelNfo.add((Component)lblNfoLanguage, "cell 1 6 2 1");
        this.cbNfoLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelNfo.add(this.cbNfoLanguage, "cell 1 6 2 1");
        JLabel lblNfoLanguageDesc = new JLabel(TmmResourceBundle.getString("Settings.nfolanguage.desc"));
        panelNfo.add((Component)lblNfoLanguageDesc, "cell 2 7");
        JLabel lblCertificationStyle = new JLabel(TmmResourceBundle.getString("Settings.certificationformat"));
        panelNfo.add((Component)lblCertificationStyle, "flowx,cell 1 8 2 1");
        this.cbCertificationStyle = new JComboBox();
        panelNfo.add(this.cbCertificationStyle, "cell 1 8 2 1,wmin 0");
        this.chckbxCreateOutline = new JHintCheckBox(TmmResourceBundle.getString("Settings.createoutline"));
        this.chckbxCreateOutline.setToolTipText(TmmResourceBundle.getString("Settings.createoutline.hint"));
        this.chckbxCreateOutline.setHintIcon(IconManager.HINT);
        panelNfo.add((Component)this.chckbxCreateOutline, "cell 1 9 2 1");
        this.chckbxOutlineFirstSentence = new JCheckBox(TmmResourceBundle.getString("Settings.outlinefirstsentence"));
        panelNfo.add((Component)this.chckbxOutlineFirstSentence, "cell 2 10");
        this.chckbxSingleStudio = new JCheckBox(TmmResourceBundle.getString("Settings.singlestudio"));
        panelNfo.add((Component)this.chckbxSingleStudio, "cell 1 11 2 1");
        this.chckbxLockdata = new JHintCheckBox(TmmResourceBundle.getString("Settings.lockdata"));
        this.chckbxLockdata.setToolTipText(TmmResourceBundle.getString("Settings.lockdata.hint"));
        this.chckbxLockdata.setHintIcon(IconManager.HINT);
        panelNfo.add((Component)this.chckbxLockdata, "cell 1 12 2 1");
    }

    private void checkChanges() {
        CertificationStyleWrapper wrapper;
        this.settings.clearNfoFilenames();
        if (this.cbMovieNfoFilename1.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        }
        if (this.cbMovieNfoFilename2.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.MOVIE_NFO);
        }
        if ((wrapper = (CertificationStyleWrapper)this.cbCertificationStyle.getSelectedItem()) != null && this.settings.getCertificationStyle() != wrapper.style) {
            this.settings.setCertificationStyle(wrapper.style);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"movieConnector");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, this.cbNfoFormat, (Property)jComboBoxBeanProperty_1);
        autoBinding_9.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"writeCleanNfo");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxWriteCleanNfo, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"nfoLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, this.cbNfoLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"createOutline");
        BeanProperty jHintCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxCreateOutline, (Property)jHintCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"outlineFirstSentence");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxOutlineFirstSentence, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxCreateOutline, (Property)jHintCheckBoxBeanProperty, (Object)this.chckbxOutlineFirstSentence, (Property)jCheckBoxBeanProperty_1);
        autoBinding_4.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"nfoDateAddedField");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, this.cbDatefield, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSettingsBeanProperty_5 = BeanProperty.create((String)"nfoWriteSingleStudio");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_5, (Object)this.chckbxSingleStudio, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSettingsBeanProperty_6 = BeanProperty.create((String)"nfoDiscFolderInside");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_6, (Object)this.chckbxNfoDiscKodiStyle, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty movieSettingsBeanProperty_7 = BeanProperty.create((String)"nfoWriteLockdata");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_7, (Object)this.chckbxLockdata, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
    }

    private static class CertificationStyleWrapper {
        private CertificationStyle style;

        private CertificationStyleWrapper() {
        }

        public String toString() {
            String bundleTag = TmmResourceBundle.getString("Settings.certification." + this.style.name().toLowerCase(Locale.ROOT));
            return bundleTag.replace("{}", CertificationStyle.formatCertification(MediaCertification.DE_FSK16, this.style));
        }
    }
}

