/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.dialogs.MovieBulkEditorDialog;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetBatchEditMovieAction
extends TmmAction {
    private static final long serialVersionUID = -3974602352019088416L;

    public MovieSetBatchEditMovieAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.bulkedit"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.bulkedit.desc"));
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = new ArrayList<Movie>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if ((selectedMovies = selectedMovies.stream().filter(movie -> !(movie instanceof MovieSet.MovieSetMovie)).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        MovieBulkEditorDialog editor = new MovieBulkEditorDialog(selectedMovies);
        editor.setLocationRelativeTo(MainWindow.getInstance());
        editor.pack();
        editor.setVisible(true);
    }
}

