/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.tasks.MovieSetScrapeTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetScrapeMissingMoviesAction
extends TmmAction {
    private static final long serialVersionUID = -389165862194237592L;

    public MovieSetScrapeMissingMoviesAction() {
        this.putValue("Name", TmmResourceBundle.getString("movieset.scrape.missingmovies"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.scrape.missingmovies.desc"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets());
        if (selectedMovieSets.isEmpty()) {
            return;
        }
        MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
        options.loadDefaults();
        options.setMetadataScraper(MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE_SET));
        MovieSetScrapeTask scrapeTask = new MovieSetScrapeTask(selectedMovieSets, options, new ArrayList<MovieSetScraperMetadataConfig>());
        TmmTaskManager.getInstance().addMainTask(scrapeTask);
    }
}

