/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;
import org.tinymediamanager.ui.panels.MediaFilesPanel;

public class MovieSetMediaInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1610264727610254912L;
    private final MovieSetSelectionModel selectionModel;
    private final EventList<MediaFile> mediaFileEventList;
    private MediaFilesPanel panelMediaFiles;

    public MovieSetMediaInformationPanel(MovieSetSelectionModel model) {
        this.selectionModel = model;
        this.mediaFileEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFile.class));
        this.initComponents();
        this.panelMediaFiles.installTmmUILayoutStore("moviesets.movieset");
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSetSelectionModel.class) {
                return;
            }
            if ("selectedMovieSet".equals(property) || "mediaInformation".equals(property) || "mediaFiles".equals(property)) {
                try {
                    this.mediaFileEventList.getReadWriteLock().writeLock().lock();
                    this.mediaFileEventList.clear();
                    this.mediaFileEventList.addAll(this.selectionModel.getSelectedMovieSet().getMediaFiles());
                }
                catch (Exception exception) {
                }
                finally {
                    this.mediaFileEventList.getReadWriteLock().writeLock().unlock();
                }
                this.panelMediaFiles.adjustColumns();
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][150lp][grow]", "[80lp,grow]"));
        this.panelMediaFiles = new MediaFilesPanel(this.mediaFileEventList){

            @Override
            public MediaEntity getMediaEntity() {
                return MovieSetMediaInformationPanel.this.selectionModel.getSelectedMovieSet();
            }
        };
        this.add((Component)this.panelMediaFiles, "cell 0 0 3 1,grow");
    }
}

