/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.panels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.CertificationImageConverter;
import org.tinymediamanager.ui.converter.RatingConverter;
import org.tinymediamanager.ui.converter.RuntimeConverter;
import org.tinymediamanager.ui.converter.ZeroIdConverter;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieSetMissingMovieInformationPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetMissingMovieInformationPanel.class);
    private static final long serialVersionUID = -8527285262749511617L;
    private final MovieSelectionModel movieSelectionModel;
    private final RatingConverter<MediaRating> ratingRatingConverter = new RatingConverter();
    private StarRater starRater;
    private JLabel lblMovieName;
    private JLabel lblRating;
    private JLabel lblYear;
    private LinkLabel lblImdbid;
    private JLabel lblRunningTime;
    private LinkLabel lblTmdbid;
    private JTextPane taGenres;
    private JTextPane taPlot;
    private ImageLabel lblMoviePoster;
    private ImageLabel lblMovieFanart;
    private JLabel lblCertification;
    private JLabel lblOriginalTitle;
    private JScrollPane scrollPane;
    private JTextPane taProduction;
    private JTextPane taTags;
    private JLabel lblSpokenLanguages;
    private JLabel lblCountry;
    private JLabel lblReleaseDate;
    private JLabel lblCertificationLogo;

    public MovieSetMissingMovieInformationPanel(MovieSelectionModel movieSelectionModel) {
        this.movieSelectionModel = movieSelectionModel;
        this.initComponents();
        this.initDataBindings();
        this.lblTmdbid.addActionListener(arg0 -> {
            String url = "https://www.themoviedb.org/movie/" + this.lblTmdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to tmdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblImdbid.addActionListener(arg0 -> {
            String url = "https://www.imdb.com/title/" + this.lblImdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to imdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSelectionModel.class) {
                return;
            }
            MovieSelectionModel selectionModel = (MovieSelectionModel)source;
            Movie movie = selectionModel.getSelectedMovie();
            if (!(movie instanceof MovieSet.MovieSetMovie)) {
                return;
            }
            if ("selectedMovie".equals(property) || "poster".equals(property)) {
                this.setPoster(movie);
            }
            if ("selectedMovie".equals(property) || "fanart".equals(property)) {
                this.setFanart(movie);
            }
            if ("selectedMovie".equals(property)) {
                SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(0));
                this.setRating(movie);
            }
        };
        movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.putClientProperty("class", "roundedPanel");
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 250]", "[][grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0 1 2,grow");
        this.lblMoviePoster = new ImageLabel(false, false, true);
        this.lblMoviePoster.setDesiredAspectRatio(0.6666667f);
        this.lblMoviePoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblMoviePoster.setPreferCache(true);
        this.lblMoviePoster.enableLightbox();
        panelLeft.add(this.lblMoviePoster);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblMovieFanart = new ImageLabel(false, false, true);
        this.lblMovieFanart.setDesiredAspectRatio(1.7777778f);
        this.lblMovieFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblMovieFanart.setPreferCache(true);
        this.lblMovieFanart.enableLightbox();
        panelLeft.add(this.lblMovieFanart);
        JPanel panelTitle = new JPanel();
        this.add((Component)panelTitle, "cell 1 0,grow");
        panelTitle.setLayout((LayoutManager)new MigLayout("insets 0 0 n n", "[grow][]", "[][][shrink 0]"));
        this.lblMovieName = new TmmLabel("", 1.33);
        panelTitle.add((Component)this.lblMovieName, "flowx,cell 0 0,wmin 0,growx");
        this.lblOriginalTitle = new JLabel("");
        panelTitle.add((Component)this.lblOriginalTitle, "cell 0 1,growx,wmin 0");
        panelTitle.add((Component)new JSeparator(), "cell 0 2 2 1,growx");
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("insets n 0 n n, hidemode 2", "[100lp,grow]", "[shrink 0][][shrink 0][][][grow,top][][]"));
        this.scrollPane = new NoBorderScrollPane(panelRight);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.add((Component)this.scrollPane, "cell 1 1,grow, wmin 0");
        JPanel panelTopDetails = new JPanel();
        panelRight.add((Component)panelTopDetails, "cell 0 0,grow");
        panelTopDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][][40lp][][grow][]", "[]2lp[]2lp[grow]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblYearT = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        panelTopDetails.add((Component)lblYearT, "cell 0 0");
        this.lblYear = new JLabel("");
        panelTopDetails.add((Component)this.lblYear, "cell 1 0,growx");
        TmmLabel lblImdbIdT = new TmmLabel(TmmResourceBundle.getString("metatag.imdb"));
        panelTopDetails.add((Component)lblImdbIdT, "cell 3 0");
        this.lblImdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblImdbid, "cell 4 0");
        this.lblCertificationLogo = new JLabel("");
        panelTopDetails.add((Component)this.lblCertificationLogo, "cell 5 0 1 3, top");
        TmmLabel lblReleaseDateT = new TmmLabel(TmmResourceBundle.getString("metatag.releasedate"));
        panelTopDetails.add((Component)lblReleaseDateT, "cell 0 1");
        this.lblReleaseDate = new JLabel("");
        panelTopDetails.add((Component)this.lblReleaseDate, "cell 1 1");
        TmmLabel lblTmdbIdT = new TmmLabel(TmmResourceBundle.getString("metatag.tmdb"));
        panelTopDetails.add((Component)lblTmdbIdT, "cell 3 1");
        this.lblTmdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblTmdbid, "cell 4 1");
        TmmLabel lblCertificationT = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        panelTopDetails.add((Component)lblCertificationT, "cell 0 2");
        this.lblCertification = new JLabel("");
        panelTopDetails.add((Component)this.lblCertification, "cell 1 2,growx");
        TmmLabel lblRunningTimeT = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        panelTopDetails.add((Component)lblRunningTimeT, "cell 0 3,aligny top");
        this.lblRunningTime = new JLabel("");
        panelTopDetails.add((Component)this.lblRunningTime, "cell 1 3,aligny top");
        TmmLabel lblGenresT = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        panelTopDetails.add((Component)lblGenresT, "cell 0 4");
        this.taGenres = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taGenres, "cell 1 4 5 1,growx,wmin 0");
        TmmLabel lblProductionT = new TmmLabel(TmmResourceBundle.getString("metatag.production"));
        panelTopDetails.add((Component)lblProductionT, "cell 0 5");
        this.taProduction = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taProduction, "cell 1 5 5 1,growx,wmin 0");
        TmmLabel lblCountryT = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        panelTopDetails.add((Component)lblCountryT, "cell 0 6");
        this.lblCountry = new JLabel("");
        panelTopDetails.add((Component)this.lblCountry, "cell 1 6 5 1,wmin 0");
        TmmLabel lblSpokenLanguagesT = new TmmLabel(TmmResourceBundle.getString("metatag.spokenlanguages"));
        panelTopDetails.add((Component)lblSpokenLanguagesT, "cell 0 7,wmin 0");
        this.lblSpokenLanguages = new JLabel("");
        panelTopDetails.add((Component)this.lblSpokenLanguages, "cell 1 7 5 1");
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        this.starRater = new StarRater(10, 1);
        panelRight.add((Component)this.starRater, "flowx,cell 0 2,aligny center");
        this.starRater.setEnabled(false);
        this.lblRating = new JLabel("");
        panelRight.add((Component)this.lblRating, "cell 0 2,aligny center");
        panelRight.add((Component)new JSeparator(), "cell 0 3,growx");
        TmmLabel lblPlotT = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelRight.add((Component)lblPlotT, "cell 0 4,alignx left,aligny top");
        this.taPlot = new ReadOnlyTextPane();
        panelRight.add((Component)this.taPlot, "cell 0 5,growx,wmin 0,aligny top");
        panelRight.add((Component)new JSeparator(), "cell 0 6,growx");
        JPanel panelBottomDetails = new JPanel();
        panelRight.add((Component)panelBottomDetails, "cell 0 7,grow");
        panelBottomDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][200lp,grow]", "[]"));
        TmmLabel lblTagsT = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelBottomDetails.add((Component)lblTagsT, "cell 0 0");
        this.taTags = new ReadOnlyTextPane();
        panelBottomDetails.add((Component)this.taTags, "cell 1 0,growx,wmin 0");
    }

    private void setPoster(Movie movie) {
        this.lblMoviePoster.clearImage();
        this.lblMoviePoster.setImageUrl(movie.getArtworkUrl(MediaFileType.POSTER));
    }

    private void setFanart(Movie movie) {
        this.lblMovieFanart.clearImage();
        this.lblMovieFanart.setImageUrl(movie.getArtworkUrl(MediaFileType.FANART));
    }

    private void setRating(Movie movie) {
        MediaRating rating = movie.getRating();
        if (rating == null) {
            this.starRater.setRating(0.0f);
            this.lblRating.setText("");
        } else {
            this.starRater.setRating(rating.getRatingNormalized());
            this.lblRating.setText(this.ratingRatingConverter.convertForward(rating));
        }
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedMovie.year");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_8, (Object)this.lblYear, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty movieSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedMovie.imdbId");
        BeanProperty JTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_12, (Object)this.lblImdbid, (Property)JTextPaneBeanProperty);
        autoBinding_10.bind();
        BeanProperty movieSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedMovie.runtime");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_13, (Object)this.lblRunningTime, (Property)jLabelBeanProperty);
        autoBinding_14.setConverter((Converter)new RuntimeConverter());
        autoBinding_14.bind();
        BeanProperty movieSelectionModelBeanProperty_15 = BeanProperty.create((String)"selectedMovie.tmdbId");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_15, (Object)this.lblTmdbid, (Property)JTextPaneBeanProperty);
        autoBinding_7.setConverter((Converter)new ZeroIdConverter());
        autoBinding_7.bind();
        BeanProperty movieSelectionModelBeanProperty_16 = BeanProperty.create((String)"selectedMovie.genresAsString");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_16, (Object)this.taGenres, (Property)JTextPaneBeanProperty);
        autoBinding_17.bind();
        BeanProperty movieSelectionModelBeanProperty_14 = BeanProperty.create((String)"selectedMovie.plot");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_14, (Object)this.taPlot, (Property)JTextPaneBeanProperty);
        autoBinding_18.bind();
        BeanProperty movieSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedMovie.title");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_4, (Object)this.lblMovieName, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.certification.localizedName");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblCertification, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedMovie.originalTitle");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_6, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovie.releaseDateAsString");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.lblReleaseDate, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty movieSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedMovie.productionCompany");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_10, (Object)this.taProduction, (Property)JTextPaneBeanProperty);
        autoBinding_12.bind();
        BeanProperty movieSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedMovie.country");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_11, (Object)this.lblCountry, (Property)jLabelBeanProperty);
        autoBinding_13.bind();
        BeanProperty movieSelectionModelBeanProperty_17 = BeanProperty.create((String)"selectedMovie.localizedSpokenLanguages");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_17, (Object)this.lblSpokenLanguages, (Property)jLabelBeanProperty);
        autoBinding_15.bind();
        BeanProperty movieSelectionModelBeanProperty_20 = BeanProperty.create((String)"selectedMovie.tagsAsString");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_20, (Object)this.taTags, (Property)JTextPaneBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSelectionModelBeanProperty_23 = BeanProperty.create((String)"selectedMovie.certification");
        BeanProperty jLabelBeanProperty_2 = BeanProperty.create((String)"icon");
        AutoBinding autoBinding_23 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_23, (Object)this.lblCertificationLogo, (Property)jLabelBeanProperty_2);
        autoBinding_23.setConverter((Converter)new CertificationImageConverter());
        autoBinding_23.bind();
    }
}

