/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.ui.images.AspectRatioIcon;
import org.tinymediamanager.ui.images.AudioChannelsIcon;
import org.tinymediamanager.ui.images.GenericVideoCodecIcon;
import org.tinymediamanager.ui.images.MediaInfoIcon;
import org.tinymediamanager.ui.images.VideoFormatIcon;

public class MediaInformationLogosPanel
extends JPanel {
    private static final long serialVersionUID = -3403472105793548302L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInformationLogosPanel.class);
    private IMediaInformation mediaInformationSource;
    private JLabel lblVideoFormat = new JLabel();
    private JLabel lblAspectRatio = new JLabel();
    private JLabel lblVideoCodec = new JLabel();
    private JLabel lblVideo3d = new JLabel();
    private JLabel lblAudioCodec = new JLabel();
    private JLabel lblAudioChannels = new JLabel();
    private JLabel lblSource = new JLabel();

    public MediaInformationLogosPanel() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][][][][10lp][][][10lp][]", "[]"));
        this.add((Component)this.lblVideoFormat, "cell 0 0, bottom");
        this.add((Component)this.lblAspectRatio, "cell 1 0, bottom");
        this.add((Component)this.lblVideoCodec, "cell 2 0, bottom");
        this.add((Component)this.lblVideo3d, "cell 3 0, bottom");
        this.add((Component)this.lblAudioChannels, "cell 5 0, bottom");
        this.add((Component)this.lblAudioCodec, "cell 6 0, bottom");
        this.add((Component)this.lblSource, "cell 8 0, bottom");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mediaInformationSource != null) {
            this.updateIcons();
        }
    }

    public void setMediaInformationSource(IMediaInformation source) {
        this.mediaInformationSource = source;
        this.updateIcons();
    }

    private void updateIcons() {
        this.setIcon(this.lblVideoFormat, this.getVideoFormatIcon());
        this.setIcon(this.lblAspectRatio, this.getAspectRatioIcon());
        this.setIcon(this.lblVideoCodec, this.getVideoCodecIcon());
        this.setIcon(this.lblVideo3d, this.getVideo3dIcon());
        this.setIcon(this.lblAudioCodec, this.getAudioCodecIcon());
        this.setIcon(this.lblAudioChannels, this.getAudioChannelsIcon());
        this.setIcon(this.lblSource, this.getSourceIcon());
    }

    private void setIcon(JLabel label, Icon icon) {
        label.setIcon(icon);
        if (icon != null) {
            label.setVisible(true);
        } else {
            label.setVisible(false);
        }
    }

    private Icon getVideoFormatIcon() {
        String videoFormat = Utils.cleanFilename(this.mediaInformationSource.getMediaInfoVideoFormat());
        if (StringUtils.isBlank((CharSequence)videoFormat)) {
            return null;
        }
        try {
            return new VideoFormatIcon(videoFormat);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getAspectRatioIcon() {
        float aspectRatio = this.mediaInformationSource.getMediaInfoAspectRatio();
        if (aspectRatio == 0.0f) {
            return null;
        }
        try {
            return new AspectRatioIcon(String.format(Locale.US, "%.2f", Float.valueOf(aspectRatio)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Icon getVideoCodecIcon() {
        String videoCodec = Utils.cleanFilename(this.mediaInformationSource.getMediaInfoVideoCodec());
        if (StringUtils.isBlank((CharSequence)videoCodec)) {
            return null;
        }
        try {
            return new MediaInfoIcon("video/codec/" + videoCodec.toLowerCase(Locale.ROOT) + ".svg");
        }
        catch (Exception e) {
            try {
                return new GenericVideoCodecIcon(videoCodec);
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    private Icon getAudioCodecIcon() {
        String audioCodec = Utils.cleanFilename(this.mediaInformationSource.getMediaInfoAudioCodec());
        if (StringUtils.isBlank((CharSequence)audioCodec)) {
            return null;
        }
        try {
            return new MediaInfoIcon("audio/codec/" + audioCodec.toLowerCase(Locale.ROOT) + ".svg");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getAudioChannelsIcon() {
        int audioChannelsInt;
        try {
            audioChannelsInt = Integer.parseInt(this.mediaInformationSource.getMediaInfoAudioChannels().replace("ch", ""));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        if (audioChannelsInt == 0) {
            return null;
        }
        String text = MediaFileHelper.audioChannelInDotNotation(audioChannelsInt);
        try {
            return new AudioChannelsIcon(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getVideo3dIcon() {
        if (!this.mediaInformationSource.isVideoIn3D()) {
            return null;
        }
        try {
            return new MediaInfoIcon("video/3d.svg");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getSourceIcon() {
        MediaSource source = this.mediaInformationSource.getMediaInfoSource();
        if (source == MediaSource.UNKNOWN) {
            return null;
        }
        try {
            return new MediaInfoIcon("source/" + source.name().toLowerCase(Locale.ROOT) + ".svg");
        }
        catch (Exception e) {
            return null;
        }
    }
}

