/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.tinymediamanager.core.TmmResourceBundle;

class MemoryUsagePanel
extends JPanel {
    private static final int MB = 0x100000;
    private final Timer timer;
    private final JLabel lblMemory;
    private long maxMem;
    private long totalMem;
    private long freeMem;
    private long usedMem;

    public MemoryUsagePanel() {
        this.setLayout(new FlowLayout());
        this.setOpaque(false);
        this.setFocusable(false);
        this.getMemory();
        this.lblMemory = new JLabel();
        this.lblMemory.setHorizontalTextPosition(0);
        this.lblMemory.setMinimumSize(this.getLabelMinimumSize());
        this.lblMemory.setOpaque(false);
        this.add(this.lblMemory);
        this.setMemoryText();
        this.timer = new Timer(1000, null);
        this.timer.addActionListener(evt -> {
            this.getMemory();
            this.setMemoryText();
            this.repaint();
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    private void getMemory() {
        Runtime rt = Runtime.getRuntime();
        this.totalMem = rt.totalMemory();
        this.maxMem = rt.maxMemory();
        this.freeMem = rt.freeMemory();
        this.usedMem = this.totalMem - this.freeMem;
    }

    private void setMemoryText() {
        this.lblMemory.setText(this.usedMem / 0x100000L + " / " + this.maxMem / 0x100000L + "M");
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        int barWidth = size.width;
        int usedBarLength = (int)((long)barWidth * this.usedMem / this.maxMem);
        g.setColor(UIManager.getColor("Panel.tmmAlternateBackground"));
        g.fillRect(0, 0, usedBarLength, size.height - 1);
        super.paintComponent(g);
    }

    @Override
    public String getToolTipText() {
        long megs = 0x100000L;
        long used = this.totalMem - this.freeMem;
        long free = this.maxMem - used;
        String phys = "";
        return TmmResourceBundle.getString("tmm.memoryused") + " " + used / megs + " MiB  /  " + TmmResourceBundle.getString("tmm.memoryfree") + " " + free / megs + " MiB  /  " + TmmResourceBundle.getString("tmm.memorymax") + " " + this.maxMem / megs + " MiB" + phys;
    }

    private Dimension getLabelMinimumSize() {
        String text = this.maxMem * 10L / 0x100000L + " / " + this.maxMem / 0x100000L + "M";
        Insets insets = this.lblMemory.getInsets();
        int width = insets.left + insets.right + this.lblMemory.getFontMetrics(this.lblMemory.getFont()).stringWidth(text);
        int height = this.lblMemory.getMinimumSize().height;
        return new Dimension(width, height);
    }
}

