/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.license.License;
import org.tinymediamanager.scraper.util.UrlUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.table.NullSelectionModel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;

public abstract class TrailerPanel
extends JPanel {
    private static final long serialVersionUID = 2506465845096043845L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TrailerPanel.class);
    protected TmmTable table;
    protected SortedList<MediaTrailer> trailerEventList;

    protected void createLayout() {
        this.trailerEventList = new SortedList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MediaTrailer.class))));
        this.setLayout((LayoutManager)new MigLayout("", "[400lp,grow]", "[250lp,grow]"));
        this.table = new TmmTable((TableModel)((Object)new TmmTableModel<MediaTrailer>((EventList<MediaTrailer>)this.trailerEventList, new TrailerTableFormat()))){
            final boolean downloadEnabled;
            {
                this.downloadEnabled = License.getInstance().isValidLicense();
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                if (column == 0 && !this.downloadEnabled) {
                    comp.setEnabled(false);
                } else {
                    comp.setEnabled(true);
                }
                return comp;
            }
        };
        this.table.setSelectionModel(new NullSelectionModel());
        this.table.installComparatorChooser(this.trailerEventList);
        JScrollPane scrollPane = new JScrollPane();
        this.table.configureScrollPane(scrollPane);
        this.add((Component)scrollPane, "cell 0 0,grow");
        scrollPane.setViewportView(this.table);
        LinkListener linkListener = new LinkListener();
        this.table.addMouseListener(linkListener);
        this.table.addMouseMotionListener(linkListener);
    }

    protected abstract void downloadTrailer(MediaTrailer var1);

    protected abstract String refreshUrlFromId(MediaTrailer var1);

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MediaTrailer trailer;
            int row = TrailerPanel.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = TrailerPanel.this.table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0 && License.getInstance().isValidLicense() && (StringUtils.isNotBlank((CharSequence)(trailer = (MediaTrailer)TrailerPanel.this.trailerEventList.get(row = TrailerPanel.this.table.convertRowIndexToModel(row))).getUrl()) && trailer.getUrl().toLowerCase(Locale.ROOT).startsWith("http") || !trailer.getId().isEmpty())) {
                TrailerPanel.this.downloadTrailer(trailer);
            }
            if (col == 1) {
                trailer = (MediaTrailer)TrailerPanel.this.trailerEventList.get(row = TrailerPanel.this.table.convertRowIndexToModel(row));
                String url = trailer.getUrl();
                if (url.isEmpty()) {
                    url = TrailerPanel.this.refreshUrlFromId(trailer);
                }
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            int col = TrailerPanel.this.table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0 || col == 1) {
                TrailerPanel.this.table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int col = TrailerPanel.this.table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1) {
                TrailerPanel.this.table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int col = TrailerPanel.this.table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1 && TrailerPanel.this.table.getCursor().getType() == 12) {
                TrailerPanel.this.table.setCursor(new Cursor(0));
            }
            if ((col == 0 || col == 1) && TrailerPanel.this.table.getCursor().getType() == 0) {
                TrailerPanel.this.table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private static class TrailerTableFormat
    extends TmmTableFormat<MediaTrailer> {
        public TrailerTableFormat() {
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.BooleanComparator booleanComparator = new TmmTableFormat.BooleanComparator();
            TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "download", trailer -> {
                if (StringUtils.isNotBlank((CharSequence)trailer.getUrl()) && trailer.getUrl().toLowerCase(Locale.ROOT).startsWith("http") || !trailer.getId().isEmpty()) {
                    return IconManager.DOWNLOAD;
                }
                return null;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(imageComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, "", "play", trailer -> IconManager.PLAY, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(imageComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.nfo"), "nfo", MediaTrailer::getInNfo, Boolean.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(booleanComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.name"), "name", MediaTrailer::getName, String.class);
            col.setColumnTooltip(MediaTrailer::getName);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.source"), "source", MediaTrailer::getProvider, String.class);
            col.setColumnTooltip(MediaTrailer::getProvider);
            col.setColumnComparator(stringComparator);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.quality"), "quality", MediaTrailer::getQuality, String.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "format", trailer -> {
                String ext = UrlUtil.getExtension(trailer.getUrl()).toLowerCase(Locale.ROOT);
                if (!Settings.getInstance().getVideoFileType().contains("." + ext)) {
                    ext = "";
                }
                return ext;
            }, String.class);
            col.setColumnComparator(stringComparator);
            col.setColumnResizeable(false);
            this.addColumn(col);
        }
    }
}

