/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatTreeUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TmmTreeUI
extends FlatTreeUI {
    private Color gridColor;
    private Color gridColor2;
    private Insets margins;

    public static ComponentUI createUI(JComponent c) {
        return new TmmTreeUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.gridColor = UIManager.getColor("Table.gridColor");
        this.gridColor2 = UIManager.getColor("Table.gridColor2");
        this.margins = UIManager.getInsets("Tree.rendererMargins");
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new TmmTreeCellRenderer();
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        bounds.width = this.tree.getWidth() - bounds.x;
        super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    private class BottomBorderBorder
    extends AbstractBorder
    implements UIResource {
        private BottomBorderBorder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                FlatUIUtils.setRenderingHints((Graphics)g2d);
                g.setColor(TmmTreeUI.this.gridColor);
                g.drawLine(g.getClipBounds().x, height - 2, g.getClipBounds().width, height - 2);
                g.setColor(TmmTreeUI.this.gridColor2);
                g.drawLine(g.getClipBounds().x, height - 1, g.getClipBounds().width, height - 1);
            }
            finally {
                g2d.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (TmmTreeUI.this.margins != null) {
                return TmmTreeUI.this.margins;
            }
            return super.getBorderInsets(c);
        }
    }

    private class TmmTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TmmTreeCellRenderer() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(new BottomBorderBorder());
        }
    }
}

