/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.renderer;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MultilineTableCellRenderer
extends JTextPane
implements TableCellRenderer {
    public MultilineTableCellRenderer() {
        this.setForeground(null);
        this.setBackground(null);
        this.setOpaque(false);
        this.setAlignmentY(0.5f);
        this.setEditorKit(new CenteredEditorKit());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    private static class CenteredBoxView
    extends BoxView {
        public CenteredBoxView(Element elem, int axis) {
            super(elem, axis);
        }

        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int i;
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            int textBlockHeight = 0;
            int offset = 0;
            for (i = 0; i < spans.length; ++i) {
                textBlockHeight += spans[i];
            }
            offset = (targetSpan - textBlockHeight) / 2;
            i = 0;
            while (i < offsets.length) {
                int n = i++;
                offsets[n] = offsets[n] + offset;
            }
        }
    }

    private static class CenteredEditorKit
    extends StyledEditorKit {
        private CenteredEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new StyledViewFactory();
        }

        static class StyledViewFactory
        implements ViewFactory {
            StyledViewFactory() {
            }

            @Override
            public View create(Element elem) {
                String kind = elem.getName();
                if (kind != null) {
                    if (kind.equals("content")) {
                        return new LabelView(elem);
                    }
                    if (kind.equals("paragraph")) {
                        return new ParagraphView(elem);
                    }
                    if (kind.equals("section")) {
                        return new CenteredBoxView(elem, 1);
                    }
                    if (kind.equals("component")) {
                        return new ComponentView(elem);
                    }
                    if (kind.equals("icon")) {
                        return new IconView(elem);
                    }
                }
                return new LabelView(elem);
            }
        }
    }
}

