/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;

class FileTypesSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 9136097757447080369L;
    private Settings settings = Settings.getInstance();
    private JTextField tfVideoFiletype;
    private JList<String> listVideoFiletypes;
    private JTextField tfSubtitleFiletype;
    private JList<String> listSubtitleFiletypes;
    private JTextField tfAudioFiletype;
    private JList<String> listAudioFiletypes;
    private JTextField tfCleanupFiletype;
    private JList<String> listCleanupFiletypes;
    private JButton btnAddAudioFiletype;
    private JButton btnAddSubtitleFiletype;
    private JButton btnAddVideoFiletype;
    private JButton btnAddCleanupFiletype;
    private JButton btnRemoveCleanupFiletype;
    private JButton btnRemoveAudioFiletype;
    private JButton btnRemoveSubtitleFiletype;
    private JButton btnRemoveVideoFiletype;

    FileTypesSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddVideoFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfVideoFiletype.getText())) {
                Settings.getInstance().addVideoFileType(this.tfVideoFiletype.getText());
                this.tfVideoFiletype.setText("");
            }
        });
        this.btnRemoveVideoFiletype.addActionListener(arg0 -> {
            int row = this.listVideoFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Settings.getInstance().getVideoFileType().get(row);
                Settings.getInstance().removeVideoFileType(prefix);
            }
        });
        this.btnAddSubtitleFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfSubtitleFiletype.getText())) {
                Settings.getInstance().addSubtitleFileType(this.tfSubtitleFiletype.getText());
                this.tfSubtitleFiletype.setText("");
            }
        });
        this.btnRemoveSubtitleFiletype.addActionListener(arg0 -> {
            int row = this.listSubtitleFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Settings.getInstance().getSubtitleFileType().get(row);
                Settings.getInstance().removeSubtitleFileType(prefix);
            }
        });
        this.btnAddAudioFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfAudioFiletype.getText())) {
                Settings.getInstance().addAudioFileType(this.tfAudioFiletype.getText());
                this.tfAudioFiletype.setText("");
            }
        });
        this.btnRemoveAudioFiletype.addActionListener(arg0 -> {
            int row = this.listAudioFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Settings.getInstance().getAudioFileType().get(row);
                Settings.getInstance().removeAudioFileType(prefix);
            }
        });
        this.btnAddCleanupFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfCleanupFiletype.getText())) {
                try {
                    Pattern.compile(this.tfCleanupFiletype.getText());
                }
                catch (PatternSyntaxException ex) {
                    JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("message.regex.error"));
                    return;
                }
                Settings.getInstance().addCleanupFileType(this.tfCleanupFiletype.getText());
                this.tfCleanupFiletype.setText("");
            }
        });
        this.btnRemoveCleanupFiletype.addActionListener(arg0 -> {
            int row = this.listCleanupFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Settings.getInstance().getCleanupFileType().get(row);
                Settings.getInstance().removeCleanupFileType(prefix);
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[199.00lp][208.00][fill][]", "[top][15lp!][192.00,top][15lp!][][15lp!][]"));
        JPanel panelVideoFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[]"));
        TmmLabel lblVideoFiletypesT = new TmmLabel(TmmResourceBundle.getString("Settings.videofiletypes"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelVideoFiletypes, lblVideoFiletypesT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#file-types"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0");
        JScrollPane scrollPaneVideoFiletypes = new JScrollPane();
        panelVideoFiletypes.add((Component)scrollPaneVideoFiletypes, "cell 1 0,grow");
        this.listVideoFiletypes = new JList();
        scrollPaneVideoFiletypes.setViewportView(this.listVideoFiletypes);
        this.btnRemoveVideoFiletype = new SquareIconButton(IconManager.REMOVE_INV);
        panelVideoFiletypes.add((Component)this.btnRemoveVideoFiletype, "cell 2 0,aligny bottom, growx");
        this.btnRemoveVideoFiletype.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        this.tfVideoFiletype = new JTextField();
        panelVideoFiletypes.add((Component)this.tfVideoFiletype, "cell 1 1,growx");
        this.btnAddVideoFiletype = new SquareIconButton(IconManager.ADD_INV);
        panelVideoFiletypes.add((Component)this.btnAddVideoFiletype, "cell 2 1,growx");
        this.btnAddVideoFiletype.setToolTipText(TmmResourceBundle.getString("Button.add"));
        JPanel panelAudioFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[]"));
        TmmLabel lblAudioFiletypesT = new TmmLabel(TmmResourceBundle.getString("Settings.audiofiletypes"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel_1 = new CollapsiblePanel((JComponent)panelAudioFiletypes, lblAudioFiletypesT, true);
        collapsiblePanel_1.addExtraTitleComponent(new DocsButton("/settings#file-types"));
        this.add((Component)collapsiblePanel_1, "cell 1 0,wmin 0");
        JScrollPane scrollPaneAudioFiletypes = new JScrollPane();
        panelAudioFiletypes.add((Component)scrollPaneAudioFiletypes, "cell 1 0,grow");
        this.listAudioFiletypes = new JList();
        scrollPaneAudioFiletypes.setViewportView(this.listAudioFiletypes);
        this.btnRemoveAudioFiletype = new SquareIconButton(IconManager.REMOVE_INV);
        panelAudioFiletypes.add((Component)this.btnRemoveAudioFiletype, "cell 2 0,aligny bottom, growx");
        this.btnRemoveAudioFiletype.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        this.tfAudioFiletype = new JTextField();
        panelAudioFiletypes.add((Component)this.tfAudioFiletype, "cell 1 1,growx");
        this.btnAddAudioFiletype = new SquareIconButton(IconManager.ADD_INV);
        panelAudioFiletypes.add((Component)this.btnAddAudioFiletype, "cell 2 1, growx");
        this.btnAddAudioFiletype.setToolTipText(TmmResourceBundle.getString("Button.add"));
        JPanel panelCleanupFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp][][grow]", "[][][40.00,fill]"));
        TmmLabel lblCleanupFiletypesT = new TmmLabel(TmmResourceBundle.getString("Settings.unwantedfiletypes"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelCleanupFiletypes, lblCleanupFiletypesT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#unwanted-file-types"));
        JPanel panelSubtitleFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[]"));
        TmmLabel lblSubtitleFiletypesT = new TmmLabel(TmmResourceBundle.getString("Settings.extrafiletypes"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel_2 = new CollapsiblePanel((JComponent)panelSubtitleFiletypes, lblSubtitleFiletypesT, true);
        collapsiblePanel_2.addExtraTitleComponent(new DocsButton("/settings#file-types"));
        this.add((Component)collapsiblePanel_2, "cell 2 0,growx,wmin 0");
        JScrollPane scrollPaneSubtitleFiletypes = new JScrollPane();
        panelSubtitleFiletypes.add((Component)scrollPaneSubtitleFiletypes, "cell 1 0,grow");
        this.listSubtitleFiletypes = new JList();
        scrollPaneSubtitleFiletypes.setViewportView(this.listSubtitleFiletypes);
        this.btnRemoveSubtitleFiletype = new SquareIconButton(IconManager.REMOVE_INV);
        panelSubtitleFiletypes.add((Component)this.btnRemoveSubtitleFiletype, "cell 2 0,aligny bottom, growx");
        this.btnRemoveSubtitleFiletype.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        this.tfSubtitleFiletype = new JTextField();
        panelSubtitleFiletypes.add((Component)this.tfSubtitleFiletype, "cell 1 1,growx");
        this.btnAddSubtitleFiletype = new SquareIconButton(IconManager.ADD_INV);
        panelSubtitleFiletypes.add((Component)this.btnAddSubtitleFiletype, "cell 2 1");
        this.btnAddSubtitleFiletype.setToolTipText(TmmResourceBundle.getString("Button.add"));
        this.add((Component)collapsiblePanel, "cell 0 2 3 1,growx,wmin 0");
        JScrollPane scrollPaneCleanupFiletypes = new JScrollPane();
        panelCleanupFiletypes.add((Component)scrollPaneCleanupFiletypes, "cell 1 0,grow");
        this.listCleanupFiletypes = new JList();
        scrollPaneCleanupFiletypes.setViewportView(this.listCleanupFiletypes);
        this.btnRemoveCleanupFiletype = new SquareIconButton(IconManager.REMOVE_INV);
        panelCleanupFiletypes.add((Component)this.btnRemoveCleanupFiletype, "cell 2 0,aligny bottom");
        this.btnRemoveCleanupFiletype.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        this.tfCleanupFiletype = new JTextField();
        panelCleanupFiletypes.add((Component)this.tfCleanupFiletype, "cell 1 1,growx");
        this.btnAddCleanupFiletype = new SquareIconButton(IconManager.ADD_INV);
        panelCleanupFiletypes.add((Component)this.btnAddCleanupFiletype, "cell 2 1");
        this.btnAddCleanupFiletype.setToolTipText(TmmResourceBundle.getString("Button.add"));
        TmmLabel lblCleanupFiletypesHelpT = new TmmLabel(TmmResourceBundle.getString("Settings.cleanupfiles.help"));
        panelCleanupFiletypes.add((Component)lblCleanupFiletypesHelpT, "cell 1 2 2 1");
        JButton btnHelp = new JButton(TmmResourceBundle.getString("tmm.help"));
        panelCleanupFiletypes.add((Component)btnHelp, "cell 3 2");
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs/settings#file-types");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"videoFileType");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, this.listVideoFiletypes);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"subtitleFileType");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, this.listSubtitleFiletypes);
        jListBinding_2.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"audioFileType");
        JListBinding jListBinding_3 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, this.listAudioFiletypes);
        jListBinding_3.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"cleanupFileType");
        JListBinding jListBinding_4 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, this.listCleanupFiletypes);
        jListBinding_4.bind();
    }
}

