/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.LauncherExtraConfig;
import org.tinymediamanager.addon.FFmpegAddon;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;

class SystemSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 500841588272296493L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemSettingsPanel.class);
    private static final Pattern MEMORY_PATTERN = Pattern.compile("-Xmx([0-9]*)(.)");
    private final Settings settings = Settings.getInstance();
    private final ButtonGroup buttonGroupFfmpeg = new ButtonGroup();
    private final FFmpegAddon fFmpegAddon = new FFmpegAddon();
    private JTextField tfProxyHost;
    private JTextField tfProxyPort;
    private JTextField tfProxyUsername;
    private JPasswordField tfProxyPassword;
    private JTextField tfMediaPlayer;
    private JTextField tfMediaFramework;
    private JButton btnSearchMediaPlayer;
    private JButton btnSearchFFMpegBinary;
    private JSlider sliderMemory;
    private JLabel lblMemory;
    private JCheckBox chckbxIgnoreSSLProblems;
    private JSpinner spMaximumDownloadThreads;
    private JRadioButton rdbtnFfmpegInternal;
    private JRadioButton rdbtnFFmpegExternal;
    private JLabel lblFfmpegVersion;
    private JButton btnDownloadFfmpeg;
    private JTextField tfHttpPort;
    private JTextField tfHttpApiKey;
    private JCheckBox chkbxEnableHttpServer;

    SystemSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.initMemorySlider();
        this.btnSearchMediaPlayer.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseplayer.path");
            Path file = TmmUIHelper.selectApplication(TmmResourceBundle.getString("Button.chooseplayer"), path);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfMediaPlayer.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("chooseplayer.path", file.getParent().toString());
            }
        });
        this.btnSearchFFMpegBinary.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseffmpeg.path");
            Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("Button.chooseffmpeglocation"), path, null);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfMediaFramework.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("chooseffmpeg.path", file.getParent().toString());
            }
        });
        if (this.settings.isUseInternalMediaFramework()) {
            this.rdbtnFfmpegInternal.setSelected(true);
        } else {
            this.rdbtnFFmpegExternal.setSelected(true);
        }
        if (this.fFmpegAddon.isAvailable()) {
            this.rdbtnFfmpegInternal.setEnabled(true);
        } else {
            this.rdbtnFFmpegExternal.setSelected(true);
            this.rdbtnFfmpegInternal.setEnabled(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][][15lp!][][15lp!][][15lp!][][15lp!][]"));
        JPanel panelMediaPlayer = new JPanel();
        panelMediaPlayer.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", ""));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("Settings.mediaplayer"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelMediaPlayer, lblLanguageT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#media-player"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.tfMediaPlayer = new JTextField();
        panelMediaPlayer.add((Component)this.tfMediaPlayer, "cell 1 0 2 1");
        this.tfMediaPlayer.setColumns(35);
        this.btnSearchMediaPlayer = new JButton(TmmResourceBundle.getString("Button.chooseplayer"));
        panelMediaPlayer.add((Component)this.btnSearchMediaPlayer, "cell 1 0");
        ReadOnlyTextArea tpMediaPlayer = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.mediaplayer.hint"));
        panelMediaPlayer.add((Component)tpMediaPlayer, "cell 1 1 2 1,growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)tpMediaPlayer, TmmFontHelper.L2);
        JPanel panelMediaFramework = new JPanel();
        panelMediaFramework.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][400lp,grow][]", "[][][][]"));
        TmmLabel lblMediaFrameworkT = new TmmLabel(TmmResourceBundle.getString("Settings.mediaframework"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMediaFramework, lblMediaFrameworkT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.rdbtnFfmpegInternal = new JRadioButton(TmmResourceBundle.getString("Settings.mediaframework.internal"));
        this.buttonGroupFfmpeg.add(this.rdbtnFfmpegInternal);
        panelMediaFramework.add((Component)this.rdbtnFfmpegInternal, "cell 1 0 2 1");
        this.rdbtnFFmpegExternal = new JRadioButton(TmmResourceBundle.getString("Settings.mediaframework.external"));
        this.buttonGroupFfmpeg.add(this.rdbtnFFmpegExternal);
        panelMediaFramework.add((Component)this.rdbtnFFmpegExternal, "cell 1 1 2 1");
        this.tfMediaFramework = new JTextField();
        panelMediaFramework.add((Component)this.tfMediaFramework, "cell 2 2");
        this.tfMediaFramework.setColumns(35);
        this.btnSearchFFMpegBinary = new JButton(TmmResourceBundle.getString("Button.chooseffmpeglocation"));
        panelMediaFramework.add((Component)this.btnSearchFFMpegBinary, "cell 2 2");
        ReadOnlyTextArea tpFFMpegLocation = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.mediaframework.hint"));
        panelMediaFramework.add((Component)tpFFMpegLocation, "cell 2 3,growx");
        TmmFontHelper.changeFont((JComponent)tpFFMpegLocation, TmmFontHelper.L2);
        JPanel panelMemory = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][300lp][grow]", ""));
        JLabel lblMemoryT = new TmmLabel(TmmResourceBundle.getString("Settings.memoryborder"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMemory, lblMemoryT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#memory-settings"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        lblMemoryT = new JLabel(TmmResourceBundle.getString("Settings.memory"));
        panelMemory.add((Component)lblMemoryT, "cell 1 0,aligny top");
        this.sliderMemory = new JSlider();
        this.sliderMemory.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        ((Dictionary)labelTable).put(256, new JLabel("256"));
        ((Dictionary)labelTable).put(2048, new JLabel("2048"));
        ((Dictionary)labelTable).put(4096, new JLabel("4096"));
        ((Dictionary)labelTable).put(6144, new JLabel("6144"));
        ((Dictionary)labelTable).put(8192, new JLabel("8192"));
        this.sliderMemory.setLabelTable(labelTable);
        this.sliderMemory.setPaintTicks(true);
        this.sliderMemory.setPaintLabels(true);
        this.sliderMemory.setMinorTickSpacing(256);
        this.sliderMemory.setMinimum(256);
        this.sliderMemory.setMaximum(8192);
        this.sliderMemory.setValue(512);
        panelMemory.add((Component)this.sliderMemory, "cell 2 0,growx,aligny top");
        this.lblMemory = new JLabel("512");
        panelMemory.add((Component)this.lblMemory, "cell 3 0,aligny top");
        JLabel lblMb = new JLabel("MB");
        panelMemory.add((Component)lblMb, "cell 3 0,aligny top");
        ReadOnlyTextArea tpMemoryHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.memory.hint"));
        panelMemory.add((Component)tpMemoryHint, "cell 1 1 3 1,growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)tpMemoryHint, TmmFontHelper.L2);
        JPanel panelProxy = new JPanel();
        panelProxy.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][grow]", "[][][][]"));
        TmmLabel lblProxyT = new TmmLabel(TmmResourceBundle.getString("Settings.proxy"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelProxy, lblProxyT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#proxy-settings"));
        this.add((Component)collapsiblePanel, "cell 0 6,growx,wmin 0");
        JLabel lblProxyHostT = new JLabel(TmmResourceBundle.getString("Settings.proxyhost"));
        panelProxy.add((Component)lblProxyHostT, "cell 1 0,alignx right");
        this.tfProxyHost = new JTextField();
        panelProxy.add((Component)this.tfProxyHost, "cell 2 0");
        this.tfProxyHost.setColumns(20);
        lblProxyHostT.setLabelFor(this.tfProxyHost);
        JLabel lblProxyPortT = new JLabel(TmmResourceBundle.getString("Settings.proxyport"));
        panelProxy.add((Component)lblProxyPortT, "cell 1 1,alignx right");
        lblProxyPortT.setLabelFor(this.tfProxyPort);
        this.tfProxyPort = new JTextField();
        panelProxy.add((Component)this.tfProxyPort, "cell 2 1");
        this.tfProxyPort.setColumns(20);
        JLabel lblProxyUserT = new JLabel(TmmResourceBundle.getString("Settings.proxyuser"));
        panelProxy.add((Component)lblProxyUserT, "cell 1 2,alignx right");
        lblProxyUserT.setLabelFor(this.tfProxyUsername);
        this.tfProxyUsername = new JTextField();
        panelProxy.add((Component)this.tfProxyUsername, "cell 2 2");
        this.tfProxyUsername.setColumns(20);
        JLabel lblProxyPasswordT = new JLabel(TmmResourceBundle.getString("Settings.proxypass"));
        panelProxy.add((Component)lblProxyPasswordT, "cell 1 3,alignx right");
        lblProxyPasswordT.setLabelFor(this.tfProxyPassword);
        this.tfProxyPassword = new JPasswordField();
        this.tfProxyPassword.setColumns(20);
        panelProxy.add((Component)this.tfProxyPassword, "cell 2 3");
        JPanel panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][grow]", "[][][][grow]"));
        TmmLabel lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.api"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/http-api"));
        this.chkbxEnableHttpServer = new JCheckBox(TmmResourceBundle.getString("Settings.api.enable"));
        panelMisc.add((Component)this.chkbxEnableHttpServer, "cell 1 0 2 1");
        JLabel lblHttpPortT = new JLabel(TmmResourceBundle.getString("Settings.api.port"));
        panelMisc.add((Component)lblHttpPortT, "cell 1 1,alignx trailing");
        this.tfHttpPort = new JTextField();
        panelMisc.add((Component)this.tfHttpPort, "cell 2 1");
        this.tfHttpPort.setColumns(10);
        this.tfHttpPort.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if ((c < '0' || c > '9') && c != '\b') {
                    e.consume();
                }
            }
        });
        JLabel lblHttpApiKey = new JLabel(TmmResourceBundle.getString("Settings.api.key"));
        panelMisc.add((Component)lblHttpApiKey, "cell 1 2,alignx trailing");
        this.tfHttpApiKey = new JTextField();
        panelMisc.add((Component)this.tfHttpApiKey, "cell 2 2");
        this.tfHttpApiKey.setColumns(30);
        this.add((Component)collapsiblePanel, "cell 0 8,growx,wmin 0");
        panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][grow]"));
        lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#misc-settings-1"));
        this.add((Component)collapsiblePanel, "cell 0 10,growx,wmin 0");
        JLabel lblParallelDownloadCountT = new JLabel(TmmResourceBundle.getString("Settings.paralleldownload"));
        panelMisc.add((Component)lblParallelDownloadCountT, "cell 1 0 2 1");
        this.spMaximumDownloadThreads = new JSpinner(new SpinnerNumberModel(this.settings.getMaximumDownloadThreads(), 1, 1024, 1));
        this.spMaximumDownloadThreads.setMinimumSize(new Dimension(60, 20));
        panelMisc.add((Component)this.spMaximumDownloadThreads, "cell 1 0 2 1");
        this.chckbxIgnoreSSLProblems = new JCheckBox(TmmResourceBundle.getString("Settings.ignoressl"));
        panelMisc.add((Component)this.chckbxIgnoreSSLProblems, "cell 1 1 2 1");
        ReadOnlyTextPane tpSSLHint = new ReadOnlyTextPane();
        ((JEditorPane)tpSSLHint).setText(TmmResourceBundle.getString("Settings.ignoressl.desc"));
        TmmFontHelper.changeFont((JComponent)tpSSLHint, TmmFontHelper.L2);
        panelMisc.add((Component)tpSSLHint, "cell 2 2,grow");
    }

    private void initMemorySlider() {
        Path file = Paths.get("launcher-extra.yml", new String[0]);
        int maxMemory = 512;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                LauncherExtraConfig extraConfig = LauncherExtraConfig.readFile(file.toFile());
                Matcher matcher = MEMORY_PATTERN.matcher(String.join((CharSequence)"\n", extraConfig.jvmOpts));
                if (matcher.find()) {
                    maxMemory = Integer.parseInt(matcher.group(1));
                    String dimension = matcher.group(2);
                    if ("k".equalsIgnoreCase(dimension)) {
                        maxMemory /= 1024;
                    }
                    if ("g".equalsIgnoreCase(dimension)) {
                        maxMemory *= 1024;
                    }
                }
            }
            catch (Exception e) {
                maxMemory = 512;
            }
        }
        this.sliderMemory.setValue(maxMemory);
        this.addHierarchyListener(new HierarchyListener(){
            private boolean oldState = false;

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (this.oldState != SystemSettingsPanel.this.isShowing()) {
                    this.oldState = SystemSettingsPanel.this.isShowing();
                    if (!SystemSettingsPanel.this.isShowing()) {
                        SystemSettingsPanel.this.writeMemorySettings();
                    }
                }
            }
        });
    }

    private void writeMemorySettings() {
        int memoryAmount = this.sliderMemory.getValue();
        Path file = Paths.get("launcher-extra.yml", new String[0]);
        try {
            LauncherExtraConfig extraConfig = LauncherExtraConfig.readFile(file.toFile());
            extraConfig.jvmOpts.removeIf(option -> MEMORY_PATTERN.matcher((CharSequence)option).find());
            if (memoryAmount != 512) {
                extraConfig.jvmOpts.add("-Xmx" + memoryAmount + "m");
            }
            extraConfig.save();
        }
        catch (Exception e) {
            LOGGER.warn("Could not write memory settings - {}", (Object)e.getMessage());
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"proxyHost");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.tfProxyHost, (Property)jTextFieldBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"proxyPort");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.tfProxyPort, (Property)jTextFieldBeanProperty_1);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"proxyUsername");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.tfProxyUsername, (Property)jTextFieldBeanProperty_2);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"proxyPassword");
        BeanProperty jPasswordFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.tfProxyPassword, (Property)jPasswordFieldBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"mediaPlayer");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.tfMediaPlayer, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"mediaFramework");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.tfMediaFramework, (Property)jTextFieldBeanProperty_4);
        autoBinding_10.bind();
        BeanProperty jSliderBeanProperty = BeanProperty.create((String)"value");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.sliderMemory, (Property)jSliderBeanProperty, (Object)this.lblMemory, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"ignoreSSLProblems");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxIgnoreSSLProblems, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"maximumDownloadThreads");
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"value");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.spMaximumDownloadThreads, (Property)jSpinnerBeanProperty);
        autoBinding_5.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"useInternalMediaFramework");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.rdbtnFfmpegInternal, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"enableHttpServer");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.chkbxEnableHttpServer, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"httpServerPort");
        BeanProperty jTextFieldBeanProperty_5 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.tfHttpPort, (Property)jTextFieldBeanProperty_5);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"httpApiKey");
        BeanProperty jTextFieldBeanProperty_6 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.tfHttpApiKey, (Property)jTextFieldBeanProperty_6);
        autoBinding_12.bind();
    }
}

