/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;

public class TvShowSelectionModel
extends AbstractModelObject {
    private static final String SELECTED_TV_SHOW = "selectedTvShow";
    private final TvShow initalTvShow;
    private final PropertyChangeListener propertyChangeListener;
    private TvShow selectedTvShow;
    private TmmTreeTable treeTable;

    public TvShowSelectionModel() {
        this.selectedTvShow = this.initalTvShow = new TvShow();
        this.propertyChangeListener = evt -> {
            if (evt.getSource() == this.selectedTvShow) {
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
    }

    public void setTreeTable(TmmTreeTable treeTable) {
        this.treeTable = treeTable;
    }

    public void setSelectedTvShow(TvShow tvShow) {
        if (tvShow == this.selectedTvShow) {
            return;
        }
        TvShow oldValue = this.selectedTvShow;
        if (oldValue != null && oldValue != this.initalTvShow) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (tvShow != null) {
            this.selectedTvShow = tvShow;
            this.selectedTvShow.addPropertyChangeListener(this.propertyChangeListener);
        } else {
            this.selectedTvShow = this.initalTvShow;
        }
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.selectedTvShow != null) {
            this.selectedTvShow.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange(SELECTED_TV_SHOW, oldValue, this.selectedTvShow);
    }

    public TvShow getSelectedTvShow() {
        return this.selectedTvShow;
    }

    public List<TvShow> getSelectedTvShows() {
        return this.getSelectedTvShows(false);
    }

    public List<TvShow> getSelectedTvShows(boolean withLocked) {
        SelectedObjects selectedObjects = this.getSelectedObjects(false, withLocked);
        if (selectedObjects.lockedFound) {
            TvShowSelectionModel.showLockedInformation();
        }
        return new ArrayList<TvShow>(selectedObjects.tvShows);
    }

    public List<TvShow> getSelectedTvShowsRecursive() {
        return this.getSelectedTvShowsRecursive(false);
    }

    public List<TvShow> getSelectedTvShowsRecursive(boolean withLocked) {
        SelectedObjects selectedObjects = this.getSelectedObjects(false, withLocked);
        LinkedHashSet<TvShow> selectedTvShows = new LinkedHashSet<TvShow>(selectedObjects.tvShows);
        for (TvShowSeason season : selectedObjects.seasons) {
            selectedTvShows.add(season.getTvShow());
        }
        for (TvShowEpisode episode : selectedObjects.episodes) {
            selectedTvShows.add(episode.getTvShow());
        }
        if (selectedObjects.lockedFound) {
            TvShowSelectionModel.showLockedInformation();
        }
        return new ArrayList<TvShow>(selectedTvShows);
    }

    public List<TvShowEpisode> getSelectedEpisodes() {
        return this.getSelectedEpisodes(false);
    }

    public List<TvShowEpisode> getSelectedEpisodes(boolean withLocked) {
        LinkedHashSet<TvShowEpisode> episodes = new LinkedHashSet<TvShowEpisode>();
        SelectedObjects selectedObjects = this.getSelectedObjects(false, withLocked);
        for (TvShow tvShow : selectedObjects.tvShows) {
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (episode.isDummy()) continue;
                episodes.add(episode);
            }
        }
        for (TvShowSeason season : selectedObjects.seasons) {
            for (TvShowEpisode episode : season.getEpisodes()) {
                if (episode.isDummy()) continue;
                episodes.add(episode);
            }
        }
        episodes.addAll(selectedObjects.episodes);
        if (selectedObjects.lockedFound) {
            TvShowSelectionModel.showLockedInformation();
        }
        return new ArrayList<TvShowEpisode>(episodes);
    }

    public SelectedObjects getSelectedObjects() {
        return this.getSelectedObjects(false, false);
    }

    public SelectedObjects getSelectedObjects(boolean withDummy, boolean withLocked) {
        SelectedObjects selectedObjects = new SelectedObjects();
        for (int row : this.treeTable.getSelectedRows()) {
            DefaultMutableTreeNode node = this.treeTable.getTreeNode(row);
            if (node == null) continue;
            Object userObject = node.getUserObject();
            if (userObject instanceof TvShow) {
                TvShow tvShow = (TvShow)userObject;
                if (withLocked || !tvShow.isLocked()) {
                    selectedObjects.tvShows.add(tvShow);
                    continue;
                }
                selectedObjects.lockedFound = true;
                continue;
            }
            if (userObject instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)userObject;
                if (withLocked || !season.isLocked()) {
                    if (!season.isDummy()) {
                        selectedObjects.seasons.add(season);
                        continue;
                    }
                    if (!season.isDummy() || !withDummy) continue;
                    selectedObjects.seasons.add(season);
                    continue;
                }
                selectedObjects.lockedFound = true;
                continue;
            }
            if (!(userObject instanceof TvShowEpisode)) continue;
            TvShowEpisode episode = (TvShowEpisode)userObject;
            if (withLocked || !episode.isLocked()) {
                if (!episode.isDummy()) {
                    selectedObjects.episodes.add(episode);
                    continue;
                }
                if (!episode.isDummy() || !withDummy) continue;
                selectedObjects.episodes.add(episode);
                continue;
            }
            selectedObjects.lockedFound = true;
        }
        return selectedObjects;
    }

    public List<Object> getSelectedTreeObjects() {
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (int row : this.treeTable.getSelectedRows()) {
            TvShowEpisode episode;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeTable.getValueAt(row, 0);
            if (node == null) continue;
            Object userObject = node.getUserObject();
            if (userObject instanceof TvShow) {
                TvShow tvShow = (TvShow)userObject;
                selectedObjects.add(tvShow);
                continue;
            }
            if (userObject instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)userObject;
                if (season.isDummy()) continue;
                selectedObjects.add(season);
                continue;
            }
            if (!(userObject instanceof TvShowEpisode) || (episode = (TvShowEpisode)userObject).isDummy()) continue;
            selectedObjects.add(episode);
        }
        return selectedObjects;
    }

    public static void showLockedInformation() {
        if (Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hidelockedhint"))) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] params = new Object[]{TmmResourceBundle.getString("tvshow.lockedfound.desc"), checkBox};
            JOptionPane.showMessageDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("tvshow.lockedfound"), 1);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("tvshow.hidelockedhint", String.valueOf(checkBox.isSelected()));
            }
        }
    }

    public static class SelectedObjects {
        private final Set<TvShow> tvShows = new LinkedHashSet<TvShow>();
        private final Set<TvShowSeason> seasons = new LinkedHashSet<TvShowSeason>();
        private final Set<TvShowEpisode> episodes = new LinkedHashSet<TvShowEpisode>();
        private boolean lockedFound = false;

        public Set<TvShow> getTvShows() {
            return this.tvShows;
        }

        public Set<TvShowSeason> getSeasons() {
            return this.seasons;
        }

        public Set<TvShowSeason> getSeasonsRecursive() {
            LinkedHashSet<TvShowSeason> allSeasons = new LinkedHashSet<TvShowSeason>(this.seasons);
            this.tvShows.forEach(tvShow -> allSeasons.addAll(tvShow.getSeasons()));
            return allSeasons;
        }

        public Set<TvShowEpisode> getEpisodes() {
            return this.episodes;
        }

        public Set<TvShowEpisode> getEpisodesRecursive() {
            LinkedHashSet<TvShowEpisode> allEpisodes = new LinkedHashSet<TvShowEpisode>(this.episodes);
            this.tvShows.forEach(tvShow -> allEpisodes.addAll(tvShow.getEpisodes()));
            this.seasons.forEach(season -> allEpisodes.addAll(season.getEpisodes()));
            return allEpisodes;
        }

        public boolean isLockedFound() {
            return this.lockedFound;
        }

        public boolean isEmpty() {
            return this.tvShows.isEmpty() && this.seasons.isEmpty() && this.episodes.isEmpty();
        }
    }
}

