/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeTextFilter;
import org.tinymediamanager.ui.tvshows.TvShowTreeDataProvider;

public class TvShowTreeTextFilter<E extends TmmTreeNode>
extends TmmTreeTextFilter<E> {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();

    @Override
    protected String prepareFilterText() {
        return StrgUtils.normalizeString(this.getText());
    }

    @Override
    public boolean accept(E node) {
        if (StringUtils.isBlank((CharSequence)this.filterText)) {
            return true;
        }
        if (node instanceof TvShowTreeDataProvider.AbstractTvShowTreeNode) {
            Matcher matcher;
            TvShowTreeDataProvider.AbstractTvShowTreeNode treeNode = (TvShowTreeDataProvider.AbstractTvShowTreeNode)node;
            if (this.settings.getNode() && (matcher = this.filterPattern.matcher(treeNode.toString())).find()) {
                return true;
            }
            if (this.settings.getTitle() && (matcher = this.filterPattern.matcher(treeNode.getTitle())).find()) {
                return true;
            }
            if (this.settings.getOriginalTitle() && (matcher = this.filterPattern.matcher(treeNode.getOriginalTitle())).find()) {
                return true;
            }
            if (this.settings.getNote() && (matcher = this.filterPattern.matcher(treeNode.getNote())).find()) {
                return true;
            }
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)node).children();
            while (e.hasMoreElements()) {
                if (!this.accept((TmmTreeNode)e.nextElement())) continue;
                return true;
            }
            return this.checkParent(((TmmTreeNode)node).getDataProvider().getParent((TmmTreeNode)node), this.filterPattern);
        }
        return super.accept(node);
    }

    @Override
    protected boolean checkParent(TmmTreeNode node, Pattern pattern) {
        if (node == null) {
            return false;
        }
        if (node instanceof TvShowTreeDataProvider.AbstractTvShowTreeNode) {
            TvShowTreeDataProvider.AbstractTvShowTreeNode treeNode = (TvShowTreeDataProvider.AbstractTvShowTreeNode)node;
            Matcher matcher = pattern.matcher(StrgUtils.normalizeString(treeNode.toString()));
            if (matcher.find()) {
                return true;
            }
            matcher = pattern.matcher(StrgUtils.normalizeString(treeNode.getTitle()));
            if (matcher.find()) {
                return true;
            }
            matcher = pattern.matcher(StrgUtils.normalizeString(treeNode.getOriginalTitle()));
            if (matcher.find()) {
                return true;
            }
            return this.checkParent(node.getDataProvider().getParent(node), pattern);
        }
        return super.checkParent(node, pattern);
    }
}

