/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowBulkEditorDialog;

public class TvShowBulkEditAction
extends TmmAction {
    private static final long serialVersionUID = -1193886444149690516L;

    public TvShowBulkEditAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.bulkedit"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.bulkedit.desc"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        TvShowBulkEditorDialog dialog = new TvShowBulkEditorDialog(selectedObjects.getTvShows(), selectedObjects.getEpisodesRecursive());
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
    }
}

