/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.List;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowChangeToDvdOrderAction
extends TmmAction {
    private static final long serialVersionUID = 8457297935386064655L;

    public TvShowChangeToDvdOrderAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.changetodvdorder"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.changeorder.desc"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShowEpisode> selectedEpisodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (selectedEpisodes.isEmpty()) {
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (TvShowEpisode episode : selectedEpisodes) {
            if (episode.isDvdOrder()) continue;
            episode.setDvdOrder(true);
            episode.setDvdSeason(episode.getAiredSeason());
            episode.setDvdEpisode(episode.getAiredEpisode());
            episode.setAiredEpisode(-1);
            episode.setAiredSeason(-1);
            episode.writeNFO();
            episode.saveToDb();
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

