/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowClearImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = 3452373237085274937L;

    public TvShowClearImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.clearimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(false, true);
        if (selectedObjects.isEmpty()) {
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (TvShow tvShow : selectedObjects.getTvShows()) {
            ImageCache.clearImageCacheForMediaEntity(tvShow);
        }
        for (TvShowSeason tvShowSeason : selectedObjects.getSeasonsRecursive()) {
            ImageCache.clearImageCache(tvShowSeason.getMediaFiles());
        }
        for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
            ImageCache.clearImageCacheForMediaEntity(episode);
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

