/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.tasks.TvShowMissingArtworkDownloadTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowScrapeMetadataDialog;

public class TvShowDownloadMissingArtworkAction
extends TmmAction {
    private static final long serialVersionUID = 6102632119900792735L;

    public TvShowDownloadMissingArtworkAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.downloadmissingartwork"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        TvShowScrapeMetadataDialog dialog = TvShowScrapeMetadataDialog.createArtworkScrapeDialog(TmmResourceBundle.getString("tvshow.downloadmissingartwork"));
        dialog.setVisible(true);
        if (!dialog.shouldStartScrape()) {
            return;
        }
        TvShowSearchAndScrapeOptions options = dialog.getTvShowSearchAndScrapeOptions();
        List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = dialog.getTvShowScraperMetadataConfig();
        List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = dialog.getTvShowEpisodeScraperMetadataConfig();
        TvShowMissingArtworkDownloadTask task = new TvShowMissingArtworkDownloadTask(selectedObjects.getTvShows(), selectedObjects.getEpisodesRecursive(), options, tvShowScraperMetadataConfig, episodeScraperMetadataConfig);
        TmmTaskManager.getInstance().addDownloadTask(task);
    }
}

