/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEditorDialog;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEpisodeEditorDialog;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowSeasonEditorDialog;

public class TvShowEditAction
extends TmmAction {
    private static final long serialVersionUID = -3911290901017607679L;

    public TvShowEditAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.edittvshowepisodes"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.edittvshowepisodes"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedTreeObjects();
        List selectedObjectWoLocked = selectedObjects.stream().filter(obj -> {
            if (obj instanceof TvShow && !((TvShow)obj).isLocked()) {
                return true;
            }
            if (obj instanceof TvShowSeason && !((TvShowSeason)obj).isLocked()) {
                return true;
            }
            return obj instanceof TvShowEpisode && !((TvShowEpisode)obj).isLocked();
        }).collect(Collectors.toList());
        if (selectedObjects.size() != selectedObjectWoLocked.size()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjectWoLocked.isEmpty()) {
            return;
        }
        int selectedCount = selectedObjectWoLocked.size();
        int index = 0;
        int selectedShowTab = 0;
        int selectedSeasonTab = 0;
        int selectedEpisodeTab = 0;
        do {
            TmmDialog editor;
            Object obj2;
            if ((obj2 = selectedObjectWoLocked.get(index)) instanceof TvShow) {
                TvShow tvShow = (TvShow)obj2;
                editor = new TvShowEditorDialog(tvShow, index, selectedCount, selectedShowTab);
                editor.setVisible(true);
                selectedShowTab = ((TvShowEditorDialog)editor).getSelectedTab();
                if (!((TvShowEditorDialog)editor).isContinueQueue()) break;
                index = ((TvShowEditorDialog)editor).isNavigateBack() ? --index : ++index;
            }
            if (obj2 instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj2;
                editor = new TvShowSeasonEditorDialog(season, index, selectedCount, selectedSeasonTab);
                editor.setVisible(true);
                selectedSeasonTab = ((TvShowSeasonEditorDialog)editor).getSelectedTab();
                if (!((TvShowSeasonEditorDialog)editor).isContinueQueue()) break;
                index = ((TvShowSeasonEditorDialog)editor).isNavigateBack() ? --index : ++index;
            }
            if (!(obj2 instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj2;
            editor = new TvShowEpisodeEditorDialog(tvShowEpisode, index, selectedCount, selectedEpisodeTab);
            editor.setVisible(true);
            selectedEpisodeTab = ((TvShowEpisodeEditorDialog)editor).getSelectedTab();
            if (!((TvShowEpisodeEditorDialog)editor).isContinueQueue()) break;
            if (((TvShowEpisodeEditorDialog)editor).isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

