/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowFetchRatingsDialog;

public class TvShowFetchRatingsAction
extends TmmAction {
    public TvShowFetchRatingsAction() {
        this.putValue("SwingLargeIconKey", IconManager.RATING_BLUE);
        this.putValue("SmallIcon", IconManager.RATING_BLUE);
        this.putValue("Name", TmmResourceBundle.getString("tvshow.fetchratings"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(false, false);
        final Set<TvShow> tvShows = selectedObjects.getTvShows();
        final Set<TvShowEpisode> episodes = selectedObjects.getEpisodesRecursive();
        if (tvShows.isEmpty() && episodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowFetchRatingsDialog dialog = new TvShowFetchRatingsDialog();
        dialog.setVisible(true);
        final List<RatingProvider.RatingSource> sources = dialog.getSelectedRatingSources();
        if (!sources.isEmpty()) {
            TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshow.fetchratings"), tvShows.size() + episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

                @Override
                protected void doInBackground() {
                    List<MediaRating> ratings;
                    HashMap<String, Object> ids;
                    int i = 0;
                    for (TvShow tvShow : tvShows) {
                        ids = new HashMap<String, Object>(tvShow.getIds());
                        ids.put("tvShowIds", tvShow.getIds());
                        ratings = RatingProvider.getRatings(ids, sources, MediaType.TV_SHOW);
                        ratings.forEach(tvShow::setRating);
                        if (!ratings.isEmpty()) {
                            tvShow.saveToDb();
                            tvShow.writeNFO();
                        }
                        this.publishState(++i);
                        if (!this.cancel) continue;
                        break;
                    }
                    for (TvShowEpisode episode : episodes) {
                        ids = new HashMap<String, Object>(episode.getIds());
                        ids.put("tvShowIds", episode.getTvShow().getIds());
                        ids.put("seasonNr", episode.getSeason());
                        ids.put("episodeNr", episode.getEpisode());
                        ratings = RatingProvider.getRatings(ids, sources, MediaType.TV_EPISODE);
                        ratings.forEach(episode::setRating);
                        if (!ratings.isEmpty()) {
                            episode.saveToDb();
                            episode.writeNFO();
                        }
                        this.publishState(++i);
                        if (!this.cancel) continue;
                        break;
                    }
                }
            });
        }
    }
}

