/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowKodiGetWatchedAction
extends TmmAction {
    private static final long serialVersionUID = 3112210911017607679L;

    public TvShowKodiGetWatchedAction() {
        this.putValue("SwingLargeIconKey", IconManager.WATCHED_MENU);
        this.putValue("SmallIcon", IconManager.WATCHED_MENU);
        this.putValue("Name", TmmResourceBundle.getString("kodi.rpc.getwatched"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("kodi.rpc.getwatched"), selectedObjects.getEpisodesRecursive().size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                KodiRPC kodiRPC = KodiRPC.getInstance();
                int i = 0;
                for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
                    kodiRPC.readWatchedState(episode);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
            }
        });
    }
}

