/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowKodiRefreshNfoAction
extends TmmAction {
    private static final long serialVersionUID = -3911290901017607679L;

    public TvShowKodiRefreshNfoAction() {
        this.putValue("SwingLargeIconKey", IconManager.MEDIAINFO);
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("Name", TmmResourceBundle.getString("kodi.rpc.refreshnfo"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("kodi.rpc.refreshnfo"), selectedObjects.getTvShows().size() + selectedObjects.getEpisodesRecursive().size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                KodiRPC kodiRPC = KodiRPC.getInstance();
                int i = 0;
                for (TvShow tvShow : selectedObjects.getTvShows()) {
                    kodiRPC.refreshFromNfo(tvShow);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
                for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
                    kodiRPC.refreshFromNfo(episode);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
                if (this.progressDone > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    kodiRPC.updateTvShowMappings();
                }
            }
        });
    }
}

