/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowOpenFolderAction
extends TmmAction {
    private static final long serialVersionUID = 492120923459852998L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowOpenFolderAction.class);

    public TvShowOpenFolderAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.openfolder"));
        this.putValue("SmallIcon", IconManager.FOLDER_OPEN);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.openfolder.desc"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 128));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShow tvShow = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShow();
        try {
            if (Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                TmmUIHelper.openFile(tvShow.getPathNIO());
            }
        }
        catch (Exception ex) {
            LOGGER.error("open filemanager", (Throwable)ex);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow.getPathNIO(), "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
        }
    }
}

