/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRemoveAction
extends TmmAction {
    private static final long serialVersionUID = -2355545751433709417L;

    public TvShowRemoveAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.remove"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.remove"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        if (Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hideremovehint"))) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] params = new Object[]{TmmResourceBundle.getString("tvshow.remove.desc"), checkBox};
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("tvshow.remove"), 0, 3, null, options, null);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("tvshow.hideremovehint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        TmmTaskManager.getInstance().addUnnamedTask(() -> {
            for (TvShow tvShow : selectedObjects.getTvShows()) {
                TvShowModuleManager.getInstance().getTvShowList().removeTvShow(tvShow);
            }
            for (TvShowSeason season : selectedObjects.getSeasons()) {
                for (TvShowEpisode episode : season.getEpisodes()) {
                    season.getTvShow().removeEpisode(episode);
                }
            }
            for (TvShowEpisode episode : selectedObjects.getEpisodes()) {
                episode.getTvShow().removeEpisode(episode);
            }
        });
    }
}

