/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowScrapeMissingEpisodesAction
extends TmmAction {
    private static final long serialVersionUID = -389165862194237592L;

    public TvShowScrapeMissingEpisodesAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.scrape.missingepisodes"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        if (selectedTvShows.isEmpty()) {
            return;
        }
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.loadDefaults();
        TvShowScrapeTask.TvShowScrapeParams tvShowScrapeParams = new TvShowScrapeTask.TvShowScrapeParams(selectedTvShows, options, new ArrayList<TvShowScraperMetadataConfig>(), new ArrayList<TvShowEpisodeScraperMetadataConfig>());
        tvShowScrapeParams.setDoSearch(false);
        TvShowScrapeTask scrapeTask = new TvShowScrapeTask(tvShowScrapeParams);
        TmmTaskManager.getInstance().addMainTask(scrapeTask);
    }
}

