/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowChooserDialog;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowScrapeMetadataDialog;

public class TvShowScrapeNewItemsAction
extends TmmAction {
    private static final long serialVersionUID = -3365542777082781952L;

    public TvShowScrapeNewItemsAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.scrape.newitems"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 192));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processAction(ActionEvent e) {
        TvShow tvShow;
        ArrayList<TvShow> newTvShows = new ArrayList<TvShow>();
        HashMap<TvShow, List> newEpisodes = new HashMap<TvShow, List>();
        boolean lockedFound = false;
        for (TvShow tvShow2 : new ArrayList<TvShow>(TvShowModuleManager.getInstance().getTvShowList().getTvShows())) {
            if (tvShow2.isLocked()) {
                lockedFound = true;
                continue;
            }
            if (tvShow2.isNewlyAdded() && !tvShow2.isScraped()) {
                newTvShows.add(tvShow2);
                continue;
            }
            for (TvShowEpisode episode : tvShow2.getEpisodes()) {
                if (!episode.isNewlyAdded() || episode.isScraped()) continue;
                List episodes = newEpisodes.computeIfAbsent(tvShow2, k -> new ArrayList());
                episodes.add(episode);
            }
        }
        if (lockedFound) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (!newTvShows.isEmpty()) {
            void var6_9;
            int count = newTvShows.size();
            boolean bl = false;
            do {
                tvShow = (TvShow)newTvShows.get((int)var6_9);
                TvShowChooserDialog chooser = new TvShowChooserDialog(tvShow, (int)var6_9, count);
                chooser.setVisible(true);
                if (!chooser.isContinueQueue()) break;
                if (chooser.isNavigateBack()) {
                    --var6_9;
                    continue;
                }
                ++var6_9;
            } while (var6_9 < count);
        }
        for (Map.Entry entry : newEpisodes.entrySet()) {
            tvShow = (TvShow)entry.getKey();
            TvShowScrapeMetadataDialog dialog = TvShowScrapeMetadataDialog.createEpisodeScrapeDialog(TmmResourceBundle.getString("tvshowepisode.scrape") + " - \"" + tvShow.getTitle() + "\"");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tvShow.getLastScraperId(), tvShow.getLastScrapeLanguage()})) {
                dialog.setMetadataScraper(MediaScraper.getMediaScraperById(tvShow.getLastScraperId(), ScraperType.TV_SHOW));
                dialog.setLanguage(MediaLanguages.valueOf(tvShow.getLastScrapeLanguage()));
            }
            dialog.setLocationRelativeTo(MainWindow.getInstance());
            dialog.setVisible(true);
            if (!dialog.shouldStartScrape()) continue;
            TvShowEpisodeSearchAndScrapeOptions options = dialog.getTvShowEpisodeSearchAndScrapeOptions();
            List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = dialog.getTvShowEpisodeScraperMetadataConfig();
            boolean overwrite = dialog.getOverwriteExistingItems();
            TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask((List)entry.getValue(), options, episodeScraperMetadataConfig, overwrite);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }
}

