/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowSubtitleChooserDialog;

public class TvShowSubtitleSearchAction
extends TmmAction {
    private static final long serialVersionUID = -6006932119900795735L;

    public TvShowSubtitleSearchAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.search.subtitle"));
        this.putValue("SmallIcon", IconManager.SUBTITLE);
        this.putValue("SwingLargeIconKey", IconManager.SUBTITLE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.search.subtitle"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShowEpisode> episodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (episodes.isEmpty()) {
            return;
        }
        for (TvShowEpisode episode : episodes) {
            if (episode.isDisc()) continue;
            for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.VIDEO)) {
                TvShowSubtitleChooserDialog dialogEpisodeSubtitleChooser = new TvShowSubtitleChooserDialog(episode, mediaFile, episodes.size() > 1);
                if (dialogEpisodeSubtitleChooser.showDialog()) continue;
                return;
            }
        }
    }
}

