/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowSyncTraktTvAction
extends TmmAction {
    private static final long serialVersionUID = 6640292090443882545L;

    public TvShowSyncTraktTvAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.synctrakt"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.synctrakt.desc"));
        this.putValue("SmallIcon", IconManager.SYNC);
        this.putValue("SwingLargeIconKey", IconManager.SYNC);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>();
        boolean lockedFound = false;
        for (TvShow tvShow : new ArrayList<TvShow>(TvShowModuleManager.getInstance().getTvShowList().getTvShows())) {
            if (tvShow.isLocked()) {
                lockedFound = true;
                continue;
            }
            tvShows.add(tvShow);
        }
        if (lockedFound) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (!tvShows.isEmpty()) {
            TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(tvShows);
            task.setSyncCollection(true);
            task.setSyncWatched(true);
            task.setSyncRating(true);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }
}

