/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowUpdateAction
extends TmmAction {
    private static final long serialVersionUID = 7216738427209633666L;

    public TvShowUpdateAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.update"));
        this.putValue("SwingLargeIconKey", IconManager.REFRESH);
        this.putValue("SmallIcon", IconManager.REFRESH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        ArrayList<Path> tvShowFolders = new ArrayList<Path>();
        if (selectedTvShows.isEmpty()) {
            return;
        }
        for (TvShow tvShow : selectedTvShows) {
            tvShowFolders.add(tvShow.getPathNIO());
        }
        TvShowUpdateDatasourceTask task = new TvShowUpdateDatasourceTask((List<Path>)tvShowFolders);
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

