/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.dialogs.PersonEditorDialog;
import org.tinymediamanager.ui.dialogs.RatingEditorDialog;
import org.tinymediamanager.ui.dialogs.SubtitleEditorDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowBulkEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3527478264068979388L;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final Collection<TvShow> tvShowsToEdit;
    private final Collection<TvShowEpisode> tvShowEpisodesToEdit;
    private boolean episodesChanged = false;
    private boolean tvShowsChanged = false;

    public TvShowBulkEditorDialog(Collection<TvShow> tvShows, Collection<TvShowEpisode> episodes) {
        super(TmmResourceBundle.getString("tvshow.bulkedit"), "tvShowBulkEditor");
        this.tvShowsToEdit = tvShows;
        this.tvShowEpisodesToEdit = episodes;
        this.initComponents();
    }

    private void initComponents() {
        TmmTabbedPane tabbedPane = new TmmTabbedPane();
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][200lp:350lp,grow][]", "[][][][][][][]"));
        tabbedPane.add(TmmResourceBundle.getString("metatag.tvshow"), panelContent);
        TmmLabel lblGenres = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        panelContent.add((Component)lblGenres, "cell 0 0,alignx right");
        AutocompleteComboBox<MediaGenres> cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        panelContent.add(cbGenres, "cell 1 0,growx,wmin 0");
        cbGenres.setEditable(true);
        SquareIconButton btnAddGenre = new SquareIconButton(IconManager.ADD_INV);
        panelContent.add((Component)btnAddGenre, "flowx,cell 2 0");
        btnAddGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                genre = (MediaGenres)item;
            }
            if (item instanceof String) {
                genre = MediaGenres.getGenre((String)item);
            }
            if (genre != null) {
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.addToGenres(Collections.singletonList(genre));
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        SquareIconButton btnRemoveGenre = new SquareIconButton(IconManager.REMOVE_INV);
        panelContent.add((Component)btnRemoveGenre, "cell 2 0");
        btnRemoveGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = (MediaGenres)cbGenres.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeGenre(genre);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTags = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelContent.add((Component)lblTags, "cell 0 1,alignx right");
        AutocompleteComboBox<String> cbTags = new AutocompleteComboBox<String>(ListUtils.asSortedList(this.tvShowList.getTagsInTvShows()));
        panelContent.add(cbTags, "cell 1 1,growx,wmin 0");
        cbTags.setEditable(true);
        SquareIconButton btnAddTag = new SquareIconButton(IconManager.ADD_INV);
        panelContent.add((Component)btnAddTag, "flowx,cell 2 1");
        btnAddTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.addToTags(Collections.singletonList(tag));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        SquareIconButton btnRemoveTag = new SquareIconButton(IconManager.REMOVE_INV);
        panelContent.add((Component)btnRemoveTag, "cell 2 1");
        btnRemoveTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblCountry = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        panelContent.add((Component)lblCountry, "cell 0 2,alignx right");
        JTextField tfCountry = new JTextField();
        panelContent.add((Component)tfCountry, "cell 1 2,growx,wmin 0");
        SquareIconButton btnChgCountry = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnChgCountry, "flowx,cell 2 2");
        btnChgCountry.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setCountry(tfCountry.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblStudio = new TmmLabel(TmmResourceBundle.getString("metatag.studio"));
        panelContent.add((Component)lblStudio, "cell 0 3,alignx right");
        JTextField tfStudio = new JTextField();
        panelContent.add((Component)tfStudio, "cell 1 3,growx,wmin 0");
        SquareIconButton btnChgStudio = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnChgStudio, "flowx,cell 2 3");
        btnChgStudio.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setProductionCompany(tfStudio.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTvShowNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelContent.add((Component)lblTvShowNoteT, "cell 0 4,alignx right");
        JTextField tfTvShowNote = new JTextField();
        panelContent.add((Component)tfTvShowNote, "cell 1 4,growx");
        SquareIconButton btnTvShowNote = new SquareIconButton(IconManager.APPLY_INV);
        btnTvShowNote.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setNote(tfTvShowNote.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnTvShowNote, "cell 2 4");
        TmmLabel lblCertificationT = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        panelContent.add((Component)lblCertificationT, "cell 0 5, alignx right");
        JComboBox<MediaCertification> cbCertification = new JComboBox<MediaCertification>();
        for (MediaCertification cert : MediaCertification.getCertificationsforCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry())) {
            cbCertification.addItem(cert);
        }
        panelContent.add(cbCertification, "cell 1 5, growx");
        SquareIconButton btnCertification = new SquareIconButton(IconManager.APPLY_INV);
        btnCertification.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaCertification cert = (MediaCertification)((Object)((Object)cbCertification.getSelectedItem()));
            for (TvShow tvshow : this.tvShowsToEdit) {
                tvshow.setCertification(cert);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnCertification, "cell 2 5");
        JButton btnAddRating = new JButton(TmmResourceBundle.getString("rating.add"));
        panelContent.add((Component)btnAddRating, "cell 1 6");
        btnAddRating.addActionListener(e -> {
            this.tvShowsChanged = true;
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            RatingEditorDialog dialog = new RatingEditorDialog((Window)MainWindow.getInstance(), TmmResourceBundle.getString("rating.add"), rating);
            dialog.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                MediaRating mr = new MediaRating(rating.key);
                mr.setVotes(rating.votes);
                mr.setRating(rating.value);
                mr.setMaxValue(rating.maxValue);
                tvShow.setRating(mr);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][200lp:350lp,grow][]", "[][][][][][][][][][][]"));
        tabbedPane.add(TmmResourceBundle.getString("metatag.episode"), panelContent);
        ReadOnlyTextArea textArea = new ReadOnlyTextArea(TmmResourceBundle.getString("tvshow.bulkedit.episodesfromshows"));
        textArea.setWrapStyleWord(true);
        panelContent.add((Component)textArea, "cell 0 0 2 1,wmin 0,grow");
        TmmLabel lblWatched = new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
        panelContent.add((Component)lblWatched, "cell 0 1,alignx right");
        JCheckBox chckbxWatched = new JCheckBox("");
        panelContent.add((Component)chckbxWatched, "cell 1 1");
        SquareIconButton btnWatched = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnWatched, "cell 2 1");
        btnWatched.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                if (chckbxWatched.isSelected()) {
                    episode.setWatched(true);
                    if (episode.getPlaycount() != 0) continue;
                    episode.setPlaycount(1);
                    episode.setLastWatched(new Date());
                    continue;
                }
                episode.setWatched(false);
                episode.setPlaycount(0);
                episode.setLastWatched(null);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblSeason = new TmmLabel(TmmResourceBundle.getString("metatag.season"));
        panelContent.add((Component)lblSeason, "cell 0 2,alignx right");
        JSpinner spSeason = new JSpinner();
        spSeason.setModel(new SpinnerNumberModel(0, -1, 9999, 1));
        panelContent.add((Component)spSeason, "cell 1 2");
        SquareIconButton btnSeason = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnSeason, "cell 2 2");
        btnSeason.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                Integer season = (Integer)spSeason.getValue();
                episode.setSeason(season);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblDvdOrder = new TmmLabel(TmmResourceBundle.getString("metatag.dvdorder"));
        panelContent.add((Component)lblDvdOrder, "cell 0 3,alignx right");
        JCheckBox cbDvdOrder = new JCheckBox("");
        panelContent.add((Component)cbDvdOrder, "cell 1 3");
        SquareIconButton btnDvdOrder = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnDvdOrder, "cell 2 3");
        btnDvdOrder.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setDvdOrder(cbDvdOrder.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JLabel lblDisplaySeason = new JLabel(TmmResourceBundle.getString("metatag.displayseason"));
        panelContent.add((Component)lblDisplaySeason, "cell 0 4,alignx right");
        JSpinner spDisplaySeason = new JSpinner();
        spDisplaySeason.setModel(new SpinnerNumberModel(0, -1, 9999, 1));
        panelContent.add((Component)spDisplaySeason, "cell 1 4");
        SquareIconButton btnDisplaySeason = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnDisplaySeason, "cell 2 4");
        btnDisplaySeason.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                Integer season = (Integer)spDisplaySeason.getValue();
                episode.setDisplaySeason(season);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTagsEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelContent.add((Component)lblTagsEpisode, "cell 0 5,alignx right");
        AutocompleteComboBox<Object> cbTagsEpisode = new AutocompleteComboBox<Object>(this.tvShowList.getTagsInEpisodes().toArray());
        panelContent.add(cbTagsEpisode, "cell 1 5,growx,wmin 0");
        cbTagsEpisode.setEditable(true);
        SquareIconButton btnAddTagEpisode = new SquareIconButton(IconManager.ADD_INV);
        panelContent.add((Component)btnAddTagEpisode, "flowx,cell 2 5");
        btnAddTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTagsEpisode.getSelectedItem();
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.addToTags(Collections.singletonList(tag));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        SquareIconButton btnRemoveTagEpisode = new SquareIconButton(IconManager.REMOVE_INV);
        panelContent.add((Component)btnRemoveTagEpisode, "cell 2 5");
        btnRemoveTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTagsEpisode.getSelectedItem();
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblMediasourceEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        panelContent.add((Component)lblMediasourceEpisode, "cell 0 6,alignx right");
        JComboBox<MediaSource> cbMediaSourceEpisode = new JComboBox<MediaSource>(MediaSource.values());
        panelContent.add(cbMediaSourceEpisode, "cell 1 6,growx,wmin 0");
        SquareIconButton btnMediaSourceEpisode = new SquareIconButton(IconManager.APPLY_INV);
        panelContent.add((Component)btnMediaSourceEpisode, "cell 2 6");
        btnMediaSourceEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            Object obj = cbMediaSourceEpisode.getSelectedItem();
            if (obj instanceof MediaSource) {
                MediaSource mediaSource = (MediaSource)obj;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    episode.setMediaSource(mediaSource);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        TmmLabel lblEpisodeNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelContent.add((Component)lblEpisodeNoteT, "cell 0 7,alignx right");
        JTextField tfEpisodeNote = new JTextField();
        panelContent.add((Component)tfEpisodeNote, "cell 1 7,growx");
        SquareIconButton btnEpisodeNote = new SquareIconButton(IconManager.APPLY_INV);
        btnEpisodeNote.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setNote(tfEpisodeNote.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnEpisodeNote, "cell 2 7");
        TmmLabel lblEpisodePlotT = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelContent.add((Component)lblEpisodePlotT, "cell 0 8,alignx right");
        JTextField tfEpisodePlot = new JTextField();
        panelContent.add((Component)tfEpisodePlot, "cell 1 8,growx");
        SquareIconButton btnEpisodePlot = new SquareIconButton(IconManager.APPLY_INV);
        btnEpisodePlot.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setPlot(tfEpisodePlot.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnEpisodePlot, "cell 2 8");
        JButton btnAddActors = new JButton(TmmResourceBundle.getString("cast.actor.add"));
        panelContent.add((Component)btnAddActors, "cell 1 9");
        btnAddActors.addActionListener(e -> {
            this.episodesChanged = true;
            Person actor = new Person(Person.Type.ACTOR, TmmResourceBundle.getString("cast.actor.unknown"), TmmResourceBundle.getString("cast.role.unknown"));
            PersonEditorDialog dialog = new PersonEditorDialog((Window)MainWindow.getInstance(), TmmResourceBundle.getString("cast.actor.add"), actor);
            dialog.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                ArrayList<Person> actors = new ArrayList<Person>();
                actors.add(new Person(actor));
                episode.addToActors(actors);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnAddDirectors = new JButton(TmmResourceBundle.getString("cast.director.add"));
        panelContent.add((Component)btnAddDirectors, "cell 1 9");
        btnAddDirectors.addActionListener(e -> {
            this.episodesChanged = true;
            Person director = new Person(Person.Type.DIRECTOR, TmmResourceBundle.getString("director.name.unknown"), "Director");
            PersonEditorDialog dialog = new PersonEditorDialog((Window)MainWindow.getInstance(), TmmResourceBundle.getString("cast.director.add"), director);
            dialog.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                ArrayList<Person> directors = new ArrayList<Person>();
                directors.add(new Person(director));
                episode.addToDirectors(directors);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnAddRating2 = new JButton(TmmResourceBundle.getString("rating.add"));
        panelContent.add((Component)btnAddRating2, "cell 1 10");
        btnAddRating2.addActionListener(e -> {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            RatingEditorDialog dialog = new RatingEditorDialog((Window)MainWindow.getInstance(), TmmResourceBundle.getString("rating.add"), rating);
            dialog.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                MediaRating mr = new MediaRating(rating.key);
                mr.setVotes(rating.votes);
                mr.setRating(rating.value);
                mr.setMaxValue(rating.maxValue);
                episode.setRating(mr);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnAddSubtitle = new JButton(TmmResourceBundle.getString("subtitle.add"));
        panelContent.add((Component)btnAddSubtitle, "cell 1 10");
        btnAddSubtitle.addActionListener(e -> {
            MediaFileSubtitle mediaFileSubtitle = new MediaFileSubtitle();
            SubtitleEditorDialog dialog = new SubtitleEditorDialog((Window)MainWindow.getInstance(), TmmResourceBundle.getString("subtitle.add"), mediaFileSubtitle);
            dialog.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.getMainFile().addSubtitle(mediaFileSubtitle);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> {
            if (this.tvShowsChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.writeNFO();
                    tvShow.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.episodesChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode tvShowEpisode : this.tvShowEpisodesToEdit) {
                    tvShowEpisode.writeNFO();
                    tvShowEpisode.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
                HashSet<TvShow> tvShows1 = new HashSet<TvShow>();
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    tvShows1.add(episode.getTvShow());
                }
                tvShows1.addAll(this.tvShowsToEdit);
                TvShowSyncTraktTvTask tvShowSyncTraktTvTask = new TvShowSyncTraktTvTask(new ArrayList<TvShow>(tvShows1));
                tvShowSyncTraktTvTask.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
                tvShowSyncTraktTvTask.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                tvShowSyncTraktTvTask.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(tvShowSyncTraktTvTask);
            }
            this.setVisible(false);
        });
        this.addDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TvShowBulkEditorDialog.this.tvShowsChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShow tvShow : TvShowBulkEditorDialog.this.tvShowsToEdit) {
                        tvShow.writeNFO();
                        tvShow.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (TvShowBulkEditorDialog.this.episodesChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : TvShowBulkEditorDialog.this.tvShowEpisodesToEdit) {
                        episode.writeNFO();
                        episode.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }
}

