/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TableSpinnerEditor;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.components.combobox.AutoCompleteSupport;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.IdEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.PersonEditorDialog;
import org.tinymediamanager.ui.dialogs.RatingEditorDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.renderer.LeftDotTableCellRenderer;

public class TvShowEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3270218410302989845L;
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private final TvShow tvShowToEdit;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final JTabbedPane tabbedPane = new TmmTabbedPane();
    private final EventList<Person> actors;
    private final List<MediaGenres> genres = ObservableCollections.observableList(new ArrayList());
    private final EventList<MediaIdTable.MediaId> ids;
    private final EventList<MediaRatingTable.Rating> ratings;
    private final List<String> tags = ObservableCollections.observableList(new ArrayList());
    private final EventList<EpisodeEditorContainer> episodes;
    private final List<MediaTrailer> trailers = ObservableCollections.observableList(new ArrayList());
    private final int queueIndex;
    private final int queueSize;
    private List<String> extrafanarts = null;
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private JTextField tfTitle;
    private YearSpinner spYear;
    private JTextArea taPlot;
    private TmmTable tableActors;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private ImageLabel lblBanner;
    private JSpinner spRuntime;
    private JTextField tfStudio;
    private JList<MediaGenres> listGenres;
    private AutocompleteComboBox<MediaGenres> cbGenres;
    private AutoCompleteSupport<MediaGenres> cbGenresAutoCompleteSupport;
    private JSpinner spRating;
    private JComboBox<MediaCertification> cbCertification;
    private JComboBox<MediaAiredStatus> cbStatus;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private JSpinner spDateAdded;
    private DatePicker dpPremiered;
    private TmmTable tableEpisodes;
    private JTextField tfSorttitle;
    private JTextArea taNote;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfLogo;
    private JTextField tfClearLogo;
    private JTextField tfBanner;
    private JTextField tfClearArt;
    private JTextField tfThumb;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblClearart;
    private ImageLabel lblThumb;
    private ImageLabel lblCharacterart;
    private ImageLabel lblKeyart;
    private TmmTable tableIds;
    private TmmTable tableRatings;
    private JTextField tfOriginalTitle;
    private JTextField tfCountry;
    private JTextField tfCharacterart;
    private JTextField tfKeyart;
    private TmmTable tableTrailer;

    public TvShowEditorDialog(TvShow tvShow, int queueIndex, int queueSize, int selectedTab) {
        super(TmmResourceBundle.getString("tvshow.edit") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : "") + "  < " + tvShow.getPathNIO() + " >", "tvShowEditor");
        List<MediaCertification> availableCertifications;
        this.tvShowToEdit = tvShow;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ids = MediaIdTable.convertIdMapToEventList(this.tvShowToEdit.getIds());
        this.ratings = MediaRatingTable.convertRatingMapToEventList(this.tvShowToEdit.getRatings(), false);
        MediaRating userMediaRating = this.tvShowToEdit.getRating("user");
        this.actors = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.episodes = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(EpisodeEditorContainer.class));
        this.initComponents();
        this.bindingGroup = this.initDataBindings();
        this.tfTitle.setText(tvShow.getTitle());
        this.tfOriginalTitle.setText(tvShow.getOriginalTitle());
        this.tfSorttitle.setText(tvShow.getSortTitle());
        this.taPlot.setText(tvShow.getPlot());
        this.lblPoster.setImagePath(tvShow.getArtworkFilename(MediaFileType.POSTER));
        this.lblFanart.setImagePath(tvShow.getArtworkFilename(MediaFileType.FANART));
        this.lblLogo.setImagePath(tvShow.getArtworkFilename(MediaFileType.LOGO));
        this.lblClearlogo.setImagePath(tvShow.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(tvShow.getArtworkFilename(MediaFileType.CLEARART));
        this.lblThumb.setImagePath(tvShow.getArtworkFilename(MediaFileType.THUMB));
        this.lblBanner.setImagePath(tvShow.getArtworkFilename(MediaFileType.BANNER));
        this.lblCharacterart.setImagePath(tvShow.getArtworkFilename(MediaFileType.CHARACTERART));
        this.lblKeyart.setImagePath(tvShow.getArtworkFilename(MediaFileType.KEYART));
        this.tfPoster.setText(tvShow.getArtworkUrl(MediaFileType.POSTER));
        this.tfFanart.setText(tvShow.getArtworkUrl(MediaFileType.FANART));
        this.tfLogo.setText(tvShow.getArtworkUrl(MediaFileType.LOGO));
        this.tfClearLogo.setText(tvShow.getArtworkUrl(MediaFileType.CLEARLOGO));
        this.tfClearArt.setText(tvShow.getArtworkUrl(MediaFileType.CLEARART));
        this.tfThumb.setText(tvShow.getArtworkUrl(MediaFileType.THUMB));
        this.tfBanner.setText(tvShow.getArtworkUrl(MediaFileType.BANNER));
        this.tfCharacterart.setText(tvShow.getArtworkUrl(MediaFileType.CHARACTERART));
        this.tfKeyart.setText(tvShow.getArtworkUrl(MediaFileType.KEYART));
        this.tfStudio.setText(tvShow.getProductionCompany());
        this.tfCountry.setText(tvShow.getCountry());
        this.taNote.setText(tvShow.getNote());
        this.cbStatus.setSelectedItem((Object)tvShow.getStatus());
        this.spRuntime.setValue(tvShow.getRuntime());
        int year = tvShow.getYear();
        this.spYear.setValue(year);
        this.spDateAdded.setValue(tvShow.getDateAdded());
        this.spRating.setModel(new SpinnerNumberModel(userMediaRating.getRating(), 0.0, 10.0, 0.1));
        for (Person person : tvShow.getActors()) {
            this.actors.add((Object)new Person(person));
        }
        this.genres.addAll(tvShow.getGenres());
        this.tags.addAll(this.tvShowToEdit.getTags());
        if (TvShowModuleManager.getInstance().getSettings().isImageExtraFanart()) {
            this.extrafanarts = new ArrayList<String>(this.tvShowToEdit.getExtraFanartUrls());
        }
        if (!(availableCertifications = MediaCertification.getCertificationsforCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry())).contains((Object)this.tvShowToEdit.getCertification())) {
            availableCertifications.add(0, this.tvShowToEdit.getCertification());
        }
        for (MediaCertification cert : availableCertifications) {
            this.cbCertification.addItem(cert);
        }
        this.cbCertification.setSelectedItem((Object)this.tvShowToEdit.getCertification());
        ArrayList<TvShowEpisode> arrayList = new ArrayList<TvShowEpisode>(this.tvShowToEdit.getEpisodes());
        arrayList.sort(Comparator.comparing(s -> s.getMediaFiles(MediaFileType.VIDEO).get(0).getFile()));
        for (TvShowEpisode episode : arrayList) {
            EpisodeEditorContainer container = new EpisodeEditorContainer();
            container.tvShowEpisode = episode;
            container.dvdOrder = episode.isDvdOrder();
            container.season = episode.getSeason();
            container.episode = episode.getEpisode();
            this.episodes.add((Object)container);
        }
        this.trailers.addAll(tvShow.getTrailer());
        this.tableEpisodes.getColumnModel().getColumn(1).setCellRenderer(new LeftDotTableCellRenderer());
        this.tableEpisodes.getColumnModel().getColumn(2).setCellEditor(new TableSpinnerEditor());
        this.tableEpisodes.getColumnModel().getColumn(3).setCellEditor(new TableSpinnerEditor());
        TableColumnResizer.adjustColumnPreferredWidths(this.tableActors, 6);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableEpisodes, 6);
        this.tableTrailer.getColumnModel().getColumn(0).setHeaderValue(TmmResourceBundle.getString("metatag.nfo"));
        this.tableTrailer.getColumnModel().getColumn(1).setHeaderValue(TmmResourceBundle.getString("metatag.name"));
        this.tableTrailer.getColumnModel().getColumn(2).setHeaderValue(TmmResourceBundle.getString("metatag.source"));
        this.tableTrailer.getColumnModel().getColumn(3).setHeaderValue(TmmResourceBundle.getString("metatag.quality"));
        this.tableTrailer.getColumnModel().getColumn(4).setHeaderValue(TmmResourceBundle.getString("metatag.url"));
        this.tableTrailer.getColumnModel().getColumn(0).setMaxWidth(55);
        this.tableTrailer.adjustColumnPreferredWidths(5);
        this.tableTrailer.getModel().addTableModelListener(arg0 -> {
            int row;
            MediaTrailer changedTrailer;
            if (arg0.getColumn() == 0 && (changedTrailer = this.trailers.get(row = arg0.getFirstRow())).getInNfo().booleanValue()) {
                for (MediaTrailer trailer : this.trailers) {
                    if (trailer == changedTrailer) continue;
                    trailer.setInNfo(Boolean.FALSE);
                }
            }
        });
        this.tabbedPane.setSelectedIndex(selectedTab);
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    private void initComponents() {
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(this.tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel details1Panel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), details1Panel);
        details1Panel.setLayout((LayoutManager)new MigLayout("", "[][grow][50lp:75lp][][60lp:75lp][100lp:n][][25lp:n][200lp:250lp,grow]", "[][][][75lp:25%:25%,grow][][][pref!][][][][75lp:20%:20%,grow][50lp:50lp:100lp,grow 50]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        details1Panel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new JTextField();
        details1Panel.add((Component)this.tfTitle, "cell 1 0 6 1,growx");
        this.lblPoster = new ImageLabel();
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.POSTER, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblPoster, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblPoster, TvShowEditorDialog.this.tfPoster);
            }
        });
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        details1Panel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster")), "cell 8 0");
        LinkLabel lblPosterSize = new LinkLabel();
        details1Panel.add((Component)lblPosterSize, "cell 8 0");
        FlatButton btnDeletePoster = new FlatButton(IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        details1Panel.add((Component)btnDeletePoster, "cell 8 0");
        details1Panel.add((Component)this.lblPoster, "cell 8 1 1 6, grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, btnDeletePoster, MediaFileType.POSTER));
        TmmLabel lblOriginalTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.originaltitle"));
        details1Panel.add((Component)lblOriginalTitleT, "cell 0 1,alignx right");
        this.tfOriginalTitle = new JTextField();
        details1Panel.add((Component)this.tfOriginalTitle, "cell 1 1 6 1,growx");
        TmmLabel lblSortTitle = new TmmLabel(TmmResourceBundle.getString("metatag.sorttitle"));
        details1Panel.add((Component)lblSortTitle, "cell 0 2,alignx right");
        this.tfSorttitle = new JTextField();
        details1Panel.add((Component)this.tfSorttitle, "cell 1 2 6 1,growx");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        details1Panel.add((Component)lblPlot, "cell 0 3,alignx right,aligny top");
        JScrollPane scrollPanePlot = new JScrollPane();
        details1Panel.add((Component)scrollPanePlot, "cell 1 3 6 1,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPanePlot.setViewportView(this.taPlot);
        TmmLabel lblYear = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        details1Panel.add((Component)lblYear, "cell 0 4,alignx right");
        this.spYear = new YearSpinner();
        details1Panel.add((Component)this.spYear, "cell 1 4,growx");
        TmmLabel lblpremiered = new TmmLabel(TmmResourceBundle.getString("metatag.premiered"));
        details1Panel.add((Component)lblpremiered, "cell 3 4,alignx right");
        this.dpPremiered = new DatePicker(this.tvShowToEdit.getFirstAired());
        details1Panel.add((Component)this.dpPremiered, "cell 4 4 2 1,growx");
        TmmLabel lblStudio = new TmmLabel(TmmResourceBundle.getString("metatag.studio"));
        details1Panel.add((Component)lblStudio, "cell 0 5,alignx right");
        this.tfStudio = new JTextField();
        details1Panel.add((Component)this.tfStudio, "cell 1 5 6 1,growx");
        TmmLabel lblCountryT = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        details1Panel.add((Component)lblCountryT, "cell 0 6,alignx trailing");
        this.tfCountry = new JTextField();
        details1Panel.add((Component)this.tfCountry, "cell 1 6 6 1,growx");
        TmmLabel lblRuntime = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        details1Panel.add((Component)lblRuntime, "cell 0 7,alignx right");
        this.spRuntime = new JSpinner();
        details1Panel.add((Component)this.spRuntime, "flowx,cell 1 7,growx");
        TmmLabel lblMin = new TmmLabel(TmmResourceBundle.getString("metatag.minutes"));
        details1Panel.add((Component)lblMin, "cell 1 7");
        TmmLabel lblStatus = new TmmLabel(TmmResourceBundle.getString("metatag.status"));
        details1Panel.add((Component)lblStatus, "cell 3 7,alignx right");
        this.cbStatus = new JComboBox<MediaAiredStatus>(MediaAiredStatus.values());
        details1Panel.add(this.cbStatus, "cell 4 7,growx");
        TmmLabel lblCertification = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        details1Panel.add((Component)lblCertification, "cell 0 8,alignx right");
        this.cbCertification = new JComboBox();
        details1Panel.add(this.cbCertification, "cell 1 8,growx");
        TmmLabel lblRating = new TmmLabel(TmmResourceBundle.getString("metatag.userrating"));
        details1Panel.add((Component)lblRating, "cell 0 9,alignx right");
        this.spRating = new JSpinner();
        details1Panel.add((Component)this.spRating, "cell 1 9,growx");
        JLabel lblUserRatingHint = new JLabel(IconManager.HINT);
        lblUserRatingHint.setToolTipText(TmmResourceBundle.getString("edit.userrating.hint"));
        details1Panel.add((Component)lblUserRatingHint, "cell 2 9");
        TmmLabel lblRatingsT = new TmmLabel(TmmResourceBundle.getString("metatag.ratings"));
        details1Panel.add((Component)lblRatingsT, "flowy,cell 0 10,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        details1Panel.add((Component)scrollPaneRatings, "cell 1 10 4 1,grow");
        this.tableRatings = new MediaRatingTable(this.ratings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.BACKGROUND, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblFanart, MediaType.TV_SHOW);
                dialog.bindExtraFanarts(TvShowEditorDialog.this.extrafanarts);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblFanart, TvShowEditorDialog.this.tfFanart);
            }
        });
        details1Panel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart")), "cell 8 8");
        LinkLabel lblFanartSize = new LinkLabel();
        details1Panel.add((Component)lblFanartSize, "cell 8 8");
        FlatButton btnDeleteFanart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        details1Panel.add((Component)btnDeleteFanart, "cell 8 8");
        details1Panel.add((Component)this.lblFanart, "cell 8 9 1 4,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, btnDeleteFanart, MediaFileType.FANART));
        SquareIconButton btnAddRating = new SquareIconButton(new AddRatingAction());
        details1Panel.add((Component)btnAddRating, "cell 0 10,alignx right,aligny top");
        SquareIconButton btnRemoveRating = new SquareIconButton(new RemoveRatingAction());
        details1Panel.add((Component)btnRemoveRating, "cell 0 10,alignx right,aligny top");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        details1Panel.add((Component)lblNoteT, "cell 0 11,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        details1Panel.add((Component)scrollPane, "cell 1 11 6 1,grow,wmin 0");
        this.taNote = new JTextArea();
        this.taNote.setLineWrap(true);
        this.taNote.setWrapStyleWord(true);
        this.taNote.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPane.setViewportView(this.taNote);
        JPanel details2Panel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][150lp:400lp,grow][20lp:n][][150lp:300lp,grow]", "[][100lp:150lp,grow][20lp:n][100lp:150lp,grow][][grow]"));
        TmmLabel lblActors = new TmmLabel(TmmResourceBundle.getString("metatag.actors"));
        details2Panel.add((Component)lblActors, "flowy,cell 0 0 1 2,alignx right,aligny top");
        this.tableActors = new PersonTable(this.actors);
        JScrollPane scrollPaneActors = new JScrollPane();
        this.tableActors.configureScrollPane(scrollPaneActors);
        details2Panel.add((Component)scrollPaneActors, "cell 1 0 1 2,grow");
        SquareIconButton btnAddActor = new SquareIconButton(new AddActorAction());
        details2Panel.add((Component)btnAddActor, "cell 0 0,alignx right");
        SquareIconButton btnRemoveActor = new SquareIconButton(new RemoveActorAction());
        details2Panel.add((Component)btnRemoveActor, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnMoveActorUp = new SquareIconButton(new MoveActorUpAction());
        details2Panel.add((Component)btnMoveActorUp, "cell 0 0,alignx right");
        SquareIconButton btnMoveActorDown = new SquareIconButton(new MoveActorDownAction());
        details2Panel.add((Component)btnMoveActorDown, "cell 0 0,alignx right,aligny top");
        TmmLabel lblDateAdded = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 3 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 4 0");
        TmmLabel lblIds = new TmmLabel("Ids");
        details2Panel.add((Component)lblIds, "flowy,cell 3 1,alignx right,aligny top");
        this.tableIds = new MediaIdTable(this.ids);
        JScrollPane scrollPaneIds = new JScrollPane();
        this.tableIds.configureScrollPane(scrollPaneIds);
        details2Panel.add((Component)scrollPaneIds, "cell 4 1,grow");
        SquareIconButton btnAddId = new SquareIconButton(new AddIdAction());
        details2Panel.add((Component)btnAddId, "cell 3 1,alignx right");
        SquareIconButton btnRemoveId = new SquareIconButton(new RemoveIdAction());
        details2Panel.add((Component)btnRemoveId, "cell 3 1,alignx right,aligny top");
        TmmLabel lblGenres = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        details2Panel.add((Component)lblGenres, "flowy,cell 0 3,alignx right,aligny top");
        JScrollPane scrollPaneGenres = new JScrollPane();
        details2Panel.add((Component)scrollPaneGenres, "cell 1 3,grow");
        this.listGenres = new JList();
        scrollPaneGenres.setViewportView(this.listGenres);
        SquareIconButton btnAddGenre = new SquareIconButton(new AddGenreAction());
        details2Panel.add((Component)btnAddGenre, "cell 0 3,alignx right");
        SquareIconButton btnRemoveGenre = new SquareIconButton(new RemoveGenreAction());
        details2Panel.add((Component)btnRemoveGenre, "cell 0 3,alignx right,aligny top");
        SquareIconButton btnMoveGenreUp = new SquareIconButton(new MoveGenreUpAction());
        details2Panel.add((Component)btnMoveGenreUp, "cell 0 3,alignx right,aligny top");
        SquareIconButton btnMoveGenreDown = new SquareIconButton(new MoveGenreDownAction());
        details2Panel.add((Component)btnMoveGenreDown, "cell 0 3,alignx right,aligny top");
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        this.cbGenresAutoCompleteSupport = this.cbGenres.getAutoCompleteSupport();
        InputMap im = this.cbGenres.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbGenres.getActionMap().put(enterAction, new AddGenreAction());
        details2Panel.add(this.cbGenres, "cell 1 4,growx");
        TmmLabel lblTags = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 3 3,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 4 3,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        SquareIconButton btnAddTag = new SquareIconButton(new AddTagAction());
        details2Panel.add((Component)btnAddTag, "cell 3 3,alignx right");
        SquareIconButton btnRemoveTag = new SquareIconButton(new RemoveTagAction());
        details2Panel.add((Component)btnRemoveTag, "cell 3 3,alignx right,aligny top");
        SquareIconButton btnMoveTagUp = new SquareIconButton(new MoveTagUpAction());
        details2Panel.add((Component)btnMoveTagUp, "cell 3 3,alignx right,aligny top");
        SquareIconButton btnMoveTagDown = new SquareIconButton(new MoveTagDownAction());
        details2Panel.add((Component)btnMoveTagDown, "cell 3 3,alignx right,aligny top");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInTvShows());
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        im = this.cbTags.getInputMap(1);
        enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        details2Panel.add(this.cbTags, "cell 4 4,growx");
        JPanel artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[25%:35%:35%,grow][20lp:n][15%:25%:25%,grow][20lp:n][15%:25%:25%,grow]", "[][100lp:30%:30%,grow][20lp:n][][100lp:30%:30%,grow][20lp:n][][100lp:30%:30%,grow]"));
        TmmLabel lblClearlogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 0 0");
        LinkLabel lblClearlogoSize = new LinkLabel();
        artworkPanel.add((Component)lblClearlogoSize, "cell 0 0");
        FlatButton btnDeleteClearLogo = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteClearLogo.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearLogo.addActionListener(e -> {
            this.lblClearlogo.clearImage();
            this.tfClearLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearLogo, "cell 0 0");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.CLEARLOGO, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblClearlogo, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblClearlogo, TvShowEditorDialog.this.tfClearLogo);
            }
        });
        artworkPanel.add((Component)this.lblClearlogo, "cell 0 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearlogoSize, this.lblClearlogo, btnDeleteClearLogo, MediaFileType.CLEARLOGO));
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 2 0 3 1");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 2 0 3 1");
        FlatButton btnDeleteBanner = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 2 0 3 1");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.BANNER, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblBanner, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblBanner, TvShowEditorDialog.this.tfBanner);
            }
        });
        artworkPanel.add((Component)this.lblBanner, "cell 2 1 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, btnDeleteBanner, MediaFileType.BANNER));
        TmmLabel lblClearartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "cell 2 3");
        LinkLabel lblClearartSize = new LinkLabel();
        artworkPanel.add((Component)lblClearartSize, "cell 2 3");
        FlatButton btnDeleteClearart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteClearart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearart.addActionListener(e -> {
            this.lblClearart.clearImage();
            this.tfClearArt.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearart, "cell 2 3");
        this.lblClearart = new ImageLabel();
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.CLEARART, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblClearart, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblClearart, TvShowEditorDialog.this.tfClearArt);
            }
        });
        artworkPanel.add((Component)this.lblClearart, "cell 2 4,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearartSize, this.lblClearart, btnDeleteClearart, MediaFileType.CLEARART));
        TmmLabel lblLogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "cell 0 3");
        LinkLabel lblLogoSize = new LinkLabel();
        artworkPanel.add((Component)lblLogoSize, "cell 0 3");
        FlatButton btnDeleteLogo = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteLogo.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteLogo.addActionListener(e -> {
            this.lblLogo.clearImage();
            this.tfLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteLogo, "cell 0 3");
        this.lblLogo = new ImageLabel();
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.LOGO, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblLogo, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblLogo, TvShowEditorDialog.this.tfLogo);
            }
        });
        artworkPanel.add((Component)this.lblLogo, "cell 0 4,grow");
        this.lblLogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblLogoSize, this.lblLogo, btnDeleteLogo, MediaFileType.LOGO));
        TmmLabel lblKeyartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 4 3");
        LinkLabel lblKeyartSize = new LinkLabel();
        artworkPanel.add((Component)lblKeyartSize, "cell 4 3");
        FlatButton btnDeleteKeyart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteKeyart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteKeyart.addActionListener(e -> {
            this.lblKeyart.clearImage();
            this.tfKeyart.setText("");
        });
        artworkPanel.add((Component)btnDeleteKeyart, "cell 4 3");
        this.lblKeyart = new ImageLabel();
        this.lblKeyart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblKeyart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.KEYART, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblKeyart, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblKeyart, TvShowEditorDialog.this.tfKeyart);
            }
        });
        artworkPanel.add((Component)this.lblKeyart, "cell 4 4 1 4,grow");
        this.lblKeyart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblKeyartSize, this.lblKeyart, btnDeleteKeyart, MediaFileType.KEYART));
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 6");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 0 6");
        FlatButton btnDeleteThumb = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 0 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.THUMB, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblThumb, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblThumb, TvShowEditorDialog.this.tfThumb);
            }
        });
        artworkPanel.add((Component)this.lblThumb, "cell 0 7,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, btnDeleteThumb, MediaFileType.THUMB));
        TmmLabel lblCharacterartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.characterart"));
        artworkPanel.add((Component)lblCharacterartT, "cell 2 6");
        LinkLabel lblCharacterartSize = new LinkLabel();
        artworkPanel.add((Component)lblCharacterartSize, "cell 2 6");
        FlatButton btnDeleteCharacterart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteCharacterart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteCharacterart.addActionListener(e -> {
            this.lblCharacterart.clearImage();
            this.tfCharacterart.setText("");
        });
        artworkPanel.add((Component)btnDeleteCharacterart, "cell 2 6");
        this.lblCharacterart = new ImageLabel();
        this.lblCharacterart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblCharacterart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.CHARACTERART, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblCharacterart, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblCharacterart, TvShowEditorDialog.this.tfCharacterart);
            }
        });
        artworkPanel.add((Component)this.lblCharacterart, "cell 2 7, grow");
        this.lblCharacterart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblCharacterartSize, this.lblCharacterart, btnDeleteCharacterart, MediaFileType.CHARACTERART));
        artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("edit.artwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][][]"));
        TmmLabel lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        lblLogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "cell 0 2,alignx right");
        this.tfLogo = new JTextField();
        artworkPanel.add((Component)this.tfLogo, "cell 1 2,growx");
        TmmLabel lblClearLogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearLogoT, "cell 0 3,alignx right");
        this.tfClearLogo = new JTextField();
        artworkPanel.add((Component)this.tfClearLogo, "cell 1 3,growx");
        lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 4,alignx right");
        this.tfBanner = new JTextField();
        artworkPanel.add((Component)this.tfBanner, "cell 1 4,growx");
        TmmLabel lblClearArtT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearArtT, "cell 0 5,alignx right");
        this.tfClearArt = new JTextField();
        artworkPanel.add((Component)this.tfClearArt, "cell 1 5,growx");
        lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 6,alignx right");
        this.tfThumb = new JTextField();
        artworkPanel.add((Component)this.tfThumb, "cell 1 6,growx");
        lblCharacterartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.characterart"));
        artworkPanel.add((Component)lblCharacterartT, "cell 0 7,alignx trailing");
        this.tfCharacterart = new JTextField();
        artworkPanel.add((Component)this.tfCharacterart, "cell 1 7,growx");
        lblKeyartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 0 8,alignx trailing");
        this.tfKeyart = new JTextField();
        artworkPanel.add((Component)this.tfKeyart, "cell 1 8,growx");
        JPanel episodesPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.episodes"), episodesPanel);
        episodesPanel.setLayout((LayoutManager)new MigLayout("", "[][200lp:450lp,grow]", "[][100lp:200lp,grow]"));
        SquareIconButton btnCloneEpisode = new SquareIconButton(new CloneEpisodeAction());
        episodesPanel.add((Component)btnCloneEpisode, "cell 0 0");
        this.tableEpisodes = new TmmTable((TableModel)((Object)new TmmTableModel<EpisodeEditorContainer>((EventList<EpisodeEditorContainer>)GlazedListsSwing.swingThreadProxyList(this.episodes), new EpisodeTableFormat())));
        JScrollPane scrollPaneEpisodes = new JScrollPane();
        this.tableEpisodes.configureScrollPane(scrollPaneEpisodes);
        episodesPanel.add((Component)scrollPaneEpisodes, "cell 1 0 1 2,grow");
        SquareIconButton btnRemoveEpisode = new SquareIconButton(new RemoveEpisodeAction());
        episodesPanel.add((Component)btnRemoveEpisode, "cell 0 1,aligny top");
        JPanel trailerPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("Settings.trailer"), null, trailerPanel, null);
        trailerPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[100lp:250lp,grow][grow 200]"));
        TmmLabel lblTrailer = new TmmLabel(TmmResourceBundle.getString("metatag.trailer"));
        trailerPanel.add((Component)lblTrailer, "flowy,cell 0 0,alignx right,aligny top");
        SquareIconButton btnAddTrailer = new SquareIconButton(new AddTrailerAction());
        trailerPanel.add((Component)btnAddTrailer, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnRemoveTrailer = new SquareIconButton(new RemoveTrailerAction());
        trailerPanel.add((Component)btnRemoveTrailer, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnPlayTrailer = new SquareIconButton(new PlayTrailerAction());
        trailerPanel.add((Component)btnPlayTrailer, "cell 0 0,alignx right,aligny top");
        JScrollPane scrollPaneTrailer = new JScrollPane();
        trailerPanel.add((Component)scrollPaneTrailer, "cell 1 0,grow");
        this.tableTrailer = new TmmTable();
        this.tableTrailer.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tableTrailer.configureScrollPane(scrollPaneTrailer);
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbortAction());
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new OKAction());
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.tvShowToEdit.getArtworkFilename(type))) {
            this.tvShowToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.tvShowToEdit.getArtworkUrl(type))) {
            this.tvShowToEdit.setArtworkUrl(textField.getText(), type);
            this.tvShowToEdit.downloadArtwork(type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.tvShowToEdit.removeArtworkUrl(type);
        } else if (StringUtils.isBlank((CharSequence)this.tvShowToEdit.getArtworkFilename(type))) {
            this.tvShowToEdit.downloadArtwork(type);
        }
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void dispose() {
        if (this.dpPremiered != null) {
            this.dpPremiered.cleanup();
        }
        super.dispose();
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    protected BindingGroup initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.genres, this.listGenres);
        jListBinding.bind();
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding_1.bind();
        JTableBinding jTableBinding_2 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.trailers, (JTable)this.tableTrailer);
        BeanProperty trailerBeanProperty = BeanProperty.create((String)"inNfo");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty).setColumnClass(Boolean.class);
        BeanProperty trailerBeanProperty_1 = BeanProperty.create((String)"name");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_1);
        BeanProperty trailerBeanProperty_2 = BeanProperty.create((String)"provider");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_2);
        BeanProperty trailerBeanProperty_3 = BeanProperty.create((String)"quality");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_3);
        BeanProperty trailerBeanProperty_4 = BeanProperty.create((String)"url");
        jTableBinding_2.addColumnBinding((Property)trailerBeanProperty_4);
        jTableBinding_2.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jListBinding);
        bindingGroup.addBinding((Binding)jListBinding_1);
        bindingGroup.addBinding((Binding)jTableBinding_2);
        return bindingGroup;
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, JButton buttonDelete, MediaFileType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        if (imageLabel.getOriginalImageSize().width == 0 && imageLabel.getOriginalImageSize().height == 0) {
            lblSize.setText("");
            lblSize.setVisible(false);
            buttonDelete.setVisible(false);
            return;
        }
        Dimension dimension = this.tvShowToEdit.getArtworkDimension(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
        lblSize.setVisible(true);
        buttonDelete.setVisible(true);
    }

    private class PlayTrailerAction
    extends AbstractAction {
        public PlayTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.play"));
            this.putValue("SmallIcon", IconManager.PLAY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableTrailer.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableTrailer.convertRowIndexToModel(row);
                MediaTrailer selectedTrailer = TvShowEditorDialog.this.trailers.get(row);
                String url = selectedTrailer.getUrl();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception ex) {
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
                }
            } else {
                JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            }
        }
    }

    private class RemoveTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -6956921050689930101L;

        public RemoveTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableTrailer.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableTrailer.convertRowIndexToModel(row);
                TvShowEditorDialog.this.trailers.remove(row);
            }
        }
    }

    private class AddTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -4446154040952056823L;

        public AddTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTrailer trailer = new MediaTrailer();
            trailer.setName("unknown");
            trailer.setProvider("unknown");
            trailer.setQuality("unknown");
            trailer.setUrl("http://");
            TvShowEditorDialog.this.trailers.add(0, trailer);
        }
    }

    private static class EpisodeTableFormat
    extends TmmTableFormat<EpisodeEditorContainer>
    implements WritableTableFormat<EpisodeEditorContainer> {
        EpisodeTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "name", EpisodeEditorContainer::getEpisodeTitle, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", EpisodeEditorContainer::getMediaFilename, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.season"), "season", EpisodeEditorContainer::getSeason, Integer.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode"), "episode", EpisodeEditorContainer::getEpisode, Integer.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.dvdorder"), "name", EpisodeEditorContainer::isDvdOrder, Boolean.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
        }

        public boolean isEditable(EpisodeEditorContainer episodeEditorContainer, int i) {
            switch (i) {
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public EpisodeEditorContainer setColumnValue(EpisodeEditorContainer episodeEditorContainer, Object o, int i) {
            switch (i) {
                case 2: {
                    episodeEditorContainer.setSeason((Integer)o);
                    break;
                }
                case 3: {
                    episodeEditorContainer.setEpisode((Integer)o);
                    break;
                }
                case 4: {
                    episodeEditorContainer.setDvdOrder((Boolean)o);
                    break;
                }
            }
            return episodeEditorContainer;
        }
    }

    private class RemoveEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -8233854057648972649L;

        RemoveEpisodeAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshowepisode.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableEpisodes.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                TvShowEditorDialog.this.episodes.remove(row);
            }
        }
    }

    private class CloneEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -3255090541823134232L;

        CloneEpisodeAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshowepisode.clone"));
            this.putValue("SmallIcon", IconManager.COPY_INV);
            this.putValue("SwingLargeIconKey", IconManager.COPY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int row = TvShowEditorDialog.this.tableEpisodes.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                EpisodeEditorContainer origContainer = (EpisodeEditorContainer)TvShowEditorDialog.this.episodes.get(row);
                EpisodeEditorContainer newContainer = new EpisodeEditorContainer();
                newContainer.tvShowEpisode = new TvShowEpisode(origContainer.tvShowEpisode);
                newContainer.tvShowEpisode.setTitle(origContainer.tvShowEpisode.getTitle() + " (clone)");
                newContainer.episode = -1;
                newContainer.season = newContainer.tvShowEpisode.getSeason();
                TvShowEditorDialog.this.episodes.add(row + 1, (Object)newContainer);
            }
        }
    }

    private static class EpisodeEditorContainer
    extends AbstractModelObject {
        TvShowEpisode tvShowEpisode;
        int season;
        int episode;
        boolean dvdOrder = false;

        private EpisodeEditorContainer() {
        }

        public String getEpisodeTitle() {
            return this.tvShowEpisode.getTitle();
        }

        public String getMediaFilename() {
            List<MediaFile> mfs = this.tvShowEpisode.getMediaFiles(MediaFileType.VIDEO);
            if (mfs != null && !mfs.isEmpty()) {
                return mfs.get(0).getFile().toString();
            }
            return "";
        }

        public int getEpisode() {
            return this.episode;
        }

        public void setEpisode(int newValue) {
            int oldValue = this.episode;
            this.episode = newValue;
            this.firePropertyChange("episode", oldValue, newValue);
        }

        public int getSeason() {
            return this.season;
        }

        public void setSeason(int newValue) {
            int oldValue = this.season;
            this.season = newValue;
            this.firePropertyChange("season", oldValue, newValue);
        }

        public boolean isDvdOrder() {
            return this.dvdOrder;
        }

        public void setDvdOrder(boolean newValue) {
            boolean oldValue = this.dvdOrder;
            this.dvdOrder = newValue;
            this.firePropertyChange("dvdOrder", oldValue, newValue);
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        private NavigateBackAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.navigateBack = true;
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        AbortAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.abortqueue"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.continueQueue = false;
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        MoveTagDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listTags.getSelectedIndex();
            if (row < TvShowEditorDialog.this.tags.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.tags.subList(row, row + 2), -1);
                TvShowEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        MoveTagUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -1580945350962234235L;

        RemoveTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (String tag : TvShowEditorDialog.this.listTags.getSelectedValuesList()) {
                TvShowEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826950827356996L;

        RemoveIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableIds.convertRowIndexToModel(row);
                TvShowEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414553349267L;

        AddIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            IdEditorDialog dialog = new IdEditorDialog(SwingUtilities.getWindowAncestor(TvShowEditorDialog.this.tableIds), TmmResourceBundle.getString("id.add"), mediaId, ScraperType.TV_SHOW);
            dialog.setVisible(true);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                TvShowEditorDialog.this.ids.add((Object)mediaId);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 9160043031922897785L;

        AddTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)TvShowEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem("");
                    TvShowEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class MoveGenreDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        MoveGenreDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movegenredown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listGenres.getSelectedIndex();
            if (row < TvShowEditorDialog.this.genres.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.genres.subList(row, row + 2), -1);
                TvShowEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveGenreUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        MoveGenreUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movegenreup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listGenres.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.genres.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = -5459615776560234688L;

        RemoveGenreAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("genre.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MediaGenres genre : TvShowEditorDialog.this.listGenres.getSelectedValuesList()) {
                TvShowEditorDialog.this.genres.remove(genre);
            }
        }
    }

    private class AddGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = 6666302391216952247L;

        AddGenreAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("genre.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            MediaGenres newGenre = null;
            Object item = TvShowEditorDialog.this.cbGenres.getSelectedItem();
            Component editorComponent = TvShowEditorDialog.this.cbGenres.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (item instanceof MediaGenres) {
                newGenre = (MediaGenres)item;
            }
            if (item instanceof String) {
                newGenre = MediaGenres.getGenre((String)item);
            }
            if (newGenre != null && !TvShowEditorDialog.this.genres.contains(newGenre)) {
                TvShowEditorDialog.this.genres.add(newGenre);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbGenresAutoCompleteSupport.setFirstItem(null);
                    TvShowEditorDialog.this.cbGenres.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbGenresAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class MoveActorDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveActorDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.moveactordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row < TvShowEditorDialog.this.actors.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.actors.subList(row, row + 2), -1);
                TvShowEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveActorUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveActorUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.moveactorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.actors.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveActorAction
    extends AbstractAction {
        private static final long serialVersionUID = 6970920169867315771L;

        RemoveActorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.actor.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableActors.convertRowIndexToModel(row);
                TvShowEditorDialog.this.actors.remove(row);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        private static final long serialVersionUID = -5879601617842300526L;

        AddActorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.actor.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person actor = new Person(Person.Type.ACTOR, TmmResourceBundle.getString("cast.actor.unknown"), TmmResourceBundle.getString("cast.role.unknown"));
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEditorDialog.this.tableActors), TmmResourceBundle.getString("cast.actor.add"), actor);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)actor.getName()) && !actor.getName().equals(TmmResourceBundle.getString("cast.actor.unknown"))) {
                if (actor.getRole().equals(TmmResourceBundle.getString("cast.role.unknown"))) {
                    actor.setRole("");
                }
                TvShowEditorDialog.this.actors.add(0, (Object)actor);
            }
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079821950827356996L;

        private RemoveRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableRatings.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableRatings.convertRowIndexToModel(row);
                TvShowEditorDialog.this.ratings.remove(row);
            }
        }
    }

    private class AddRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414533349267L;

        private AddRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            RatingEditorDialog dialog = new RatingEditorDialog(SwingUtilities.getWindowAncestor(TvShowEditorDialog.this.tableActors), TmmResourceBundle.getString("rating.add"), rating);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)rating.key) && rating.value > 0.0f && rating.maxValue > 0 && rating.votes > 0) {
                TvShowEditorDialog.this.ratings.add((Object)rating);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -4617793684152607277L;

        CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 6699599213348390696L;

        OKAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.tvShowToEdit.setTitle(TvShowEditorDialog.this.tfTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setOriginalTitle(TvShowEditorDialog.this.tfOriginalTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setSortTitle(TvShowEditorDialog.this.tfSorttitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setYear((Integer)TvShowEditorDialog.this.spYear.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setPlot(TvShowEditorDialog.this.taPlot.getText());
            TvShowEditorDialog.this.tvShowToEdit.setRuntime((Integer)TvShowEditorDialog.this.spRuntime.getValue());
            for (Iterator id : TvShowEditorDialog.this.ids) {
                try {
                    Integer value = Integer.parseInt(((MediaIdTable.MediaId)((Object)id)).value);
                    TvShowEditorDialog.this.tvShowToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, value);
                }
                catch (NumberFormatException ex) {
                    TvShowEditorDialog.this.tvShowToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, ((MediaIdTable.MediaId)((Object)id)).value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry entry : TvShowEditorDialog.this.tvShowToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId((String)entry.getKey());
                if (TvShowEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add((String)entry.getKey());
            }
            for (String id : removeIds) {
                TvShowEditorDialog.this.tvShowToEdit.setId(id, null);
            }
            Object certification = TvShowEditorDialog.this.cbCertification.getSelectedItem();
            if (certification instanceof MediaCertification) {
                TvShowEditorDialog.this.tvShowToEdit.setCertification((MediaCertification)((Object)certification));
            }
            TvShowEditorDialog.this.processArtwork(MediaFileType.POSTER, TvShowEditorDialog.this.lblPoster, TvShowEditorDialog.this.tfPoster);
            TvShowEditorDialog.this.processArtwork(MediaFileType.FANART, TvShowEditorDialog.this.lblFanart, TvShowEditorDialog.this.tfFanart);
            TvShowEditorDialog.this.processArtwork(MediaFileType.LOGO, TvShowEditorDialog.this.lblLogo, TvShowEditorDialog.this.tfLogo);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CLEARLOGO, TvShowEditorDialog.this.lblClearlogo, TvShowEditorDialog.this.tfClearLogo);
            TvShowEditorDialog.this.processArtwork(MediaFileType.BANNER, TvShowEditorDialog.this.lblBanner, TvShowEditorDialog.this.tfBanner);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CLEARART, TvShowEditorDialog.this.lblClearart, TvShowEditorDialog.this.tfClearArt);
            TvShowEditorDialog.this.processArtwork(MediaFileType.THUMB, TvShowEditorDialog.this.lblThumb, TvShowEditorDialog.this.tfThumb);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CHARACTERART, TvShowEditorDialog.this.lblCharacterart, TvShowEditorDialog.this.tfCharacterart);
            TvShowEditorDialog.this.processArtwork(MediaFileType.KEYART, TvShowEditorDialog.this.lblKeyart, TvShowEditorDialog.this.tfKeyart);
            if (!(TvShowEditorDialog.this.extrafanarts == null || TvShowEditorDialog.this.extrafanarts.size() == TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls().size() && TvShowEditorDialog.this.extrafanarts.containsAll(TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls()) && TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls().containsAll(TvShowEditorDialog.this.extrafanarts))) {
                TvShowEditorDialog.this.tvShowToEdit.setExtraFanartUrls(TvShowEditorDialog.this.extrafanarts);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.EXTRAFANART);
            }
            TvShowEditorDialog.this.tvShowToEdit.setProductionCompany(TvShowEditorDialog.this.tfStudio.getText());
            TvShowEditorDialog.this.tvShowToEdit.setCountry(TvShowEditorDialog.this.tfCountry.getText());
            TvShowEditorDialog.this.tvShowToEdit.setNote(TvShowEditorDialog.this.taNote.getText());
            TvShowEditorDialog.this.tvShowToEdit.removeAllGenres();
            TvShowEditorDialog.this.tvShowToEdit.setGenres(TvShowEditorDialog.this.genres);
            TvShowEditorDialog.this.tvShowToEdit.removeActors();
            TvShowEditorDialog.this.tvShowToEdit.setActors((List<Person>)TvShowEditorDialog.this.actors);
            TvShowEditorDialog.this.tvShowToEdit.removeAllTags();
            TvShowEditorDialog.this.tvShowToEdit.setTags(TvShowEditorDialog.this.tags);
            TvShowEditorDialog.this.tvShowToEdit.removeAllTrailers();
            TvShowEditorDialog.this.tvShowToEdit.addToTrailer(TvShowEditorDialog.this.trailers);
            TvShowEditorDialog.this.tvShowToEdit.setDateAdded((Date)TvShowEditorDialog.this.spDateAdded.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setFirstAired(TvShowEditorDialog.this.dpPremiered.getDate());
            TvShowEditorDialog.this.tvShowToEdit.setStatus((MediaAiredStatus)((Object)TvShowEditorDialog.this.cbStatus.getSelectedItem()));
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            double userRating = (Double)TvShowEditorDialog.this.spRating.getValue();
            if (userRating > 0.0) {
                newRatings.put("user", new MediaRating("user", userRating, 1, 10));
            }
            for (MediaRatingTable.Rating rating : TvShowEditorDialog.this.ratings) {
                if (!StringUtils.isNotBlank((CharSequence)rating.key) || !(rating.value > 0.0f)) continue;
                newRatings.put(rating.key, new MediaRating(rating.key, rating.value, rating.votes, rating.maxValue));
            }
            TvShowEditorDialog.this.tvShowToEdit.setRatings(newRatings);
            if (userRating == 0.0) {
                TvShowEditorDialog.this.tvShowToEdit.removeRating("user");
            }
            for (int i = TvShowEditorDialog.this.tvShowToEdit.getEpisodeCount() - 1; i >= 0; --i) {
                boolean found = false;
                TvShowEpisode episode = TvShowEditorDialog.this.tvShowToEdit.getEpisodes().get(i);
                for (EpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                TvShowEditorDialog.this.tvShowToEdit.removeEpisode(episode);
            }
            for (EpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                boolean found = false;
                boolean shouldStore = false;
                if (container.dvdOrder != container.tvShowEpisode.isDvdOrder()) {
                    container.tvShowEpisode.setDvdOrder(container.dvdOrder);
                    shouldStore = true;
                }
                if (container.episode != container.tvShowEpisode.getEpisode()) {
                    if (container.dvdOrder) {
                        container.tvShowEpisode.setDvdEpisode(container.episode);
                    } else {
                        container.tvShowEpisode.setAiredEpisode(container.episode);
                    }
                    container.tvShowEpisode.removeAllIds();
                    shouldStore = true;
                }
                if (container.season != container.tvShowEpisode.getSeason()) {
                    if (container.dvdOrder) {
                        container.tvShowEpisode.setDvdSeason(container.season);
                    } else {
                        container.tvShowEpisode.setAiredSeason(container.season);
                    }
                    container.tvShowEpisode.removeAllIds();
                    shouldStore = true;
                }
                for (TvShowEpisode episode : TvShowEditorDialog.this.tvShowToEdit.getEpisodes()) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    container.tvShowEpisode.writeNFO();
                    container.tvShowEpisode.saveToDb();
                    TvShowEditorDialog.this.tvShowToEdit.addEpisode(container.tvShowEpisode);
                    continue;
                }
                if (!shouldStore) continue;
                container.tvShowEpisode.writeNFO();
                container.tvShowEpisode.saveToDb();
            }
            TvShowEditorDialog.this.tvShowToEdit.writeNFO();
            TvShowEditorDialog.this.tvShowToEdit.saveToDb();
            if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
                TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(Collections.singletonList(TvShowEditorDialog.this.tvShowToEdit));
                task.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
                task.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            TvShowEditorDialog.this.setVisible(false);
        }
    }
}

