/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.kodi.KodiTvShowMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowScrapeMetadataDialog
extends TmmDialog {
    private static final long serialVersionUID = 6120530120703772160L;
    private boolean startScrape = false;
    private final JComboBox cbLanguage;
    private final MediaScraperCheckComboBox cbArtworkScraper;
    private final ScraperMetadataConfigCheckComboBox<TvShowEpisodeScraperMetadataConfig> cbEpisodeScraperConfig;
    private final JHintCheckBox chckbxDoNotOverwrite;
    private MediaScraperComboBox cbMetadataScraper;
    private MediaScraperCheckComboBox cbTrailerScraper;
    private ScraperMetadataConfigCheckComboBox<TvShowScraperMetadataConfig> cbTvShowScraperConfig;

    private TvShowScrapeMetadataDialog(String title, boolean artworkOnly, boolean tvShowMetadata) {
        super(title, "tvShowUpdateMetadata");
        List<Enum> config;
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][600lp:800lp,grow]", "[][][][][shrink 0][200lp:n, grow]"));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 0,alignx trailing");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        this.cbLanguage.setSelectedItem((Object)TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
        panelContent.add((Component)this.cbLanguage, "cell 1 0,growx");
        if (!artworkOnly) {
            TmmLabel lblMetadataScraperT = new TmmLabel(TmmResourceBundle.getString("scraper.metadata"));
            panelContent.add((Component)lblMetadataScraperT, "cell 0 1,alignx trailing");
            this.cbMetadataScraper = new MediaScraperComboBox(TvShowModuleManager.getInstance().getTvShowList().getAvailableMediaScrapers().stream().filter(scraper -> !(scraper.getMediaProvider() instanceof KodiTvShowMetadataProvider)).collect(Collectors.toList()));
            panelContent.add((Component)this.cbMetadataScraper, "cell 1 1,growx");
        }
        TmmLabel lblArtworkScraper = new TmmLabel(TmmResourceBundle.getString("scraper.artwork"));
        panelContent.add((Component)lblArtworkScraper, "cell 0 2,alignx trailing");
        this.cbArtworkScraper = new MediaScraperCheckComboBox(TvShowModuleManager.getInstance().getTvShowList().getAvailableArtworkScrapers());
        panelContent.add((Component)this.cbArtworkScraper, "cell 1 2,growx");
        if (!artworkOnly) {
            TmmLabel lblTrailerScraper = new TmmLabel(TmmResourceBundle.getString("scraper.trailer"));
            panelContent.add((Component)lblTrailerScraper, "cell 0 3,alignx right");
            this.cbTrailerScraper = new MediaScraperCheckComboBox(TvShowModuleManager.getInstance().getTvShowList().getAvailableTrailerScrapers());
            panelContent.add((Component)this.cbTrailerScraper, "cell 1 3,growx");
        }
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 4 2 1,growx");
        JPanel panelScraperConfig = new JPanel();
        panelContent.add((Component)panelScraperConfig, "cell 0 5 2 1,grow");
        panelScraperConfig.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][300lp:500lp,grow]", "[][][][]"));
        TmmLabel lblScrapeFollowingItems = new TmmLabel(TmmResourceBundle.getString("chooser.scrape"));
        panelScraperConfig.add((Component)lblScrapeFollowingItems, "cell 0 0 2 1");
        if (tvShowMetadata) {
            TmmLabel lblTvShowsT = new TmmLabel(TmmResourceBundle.getString("metatag.tvshows"));
            panelScraperConfig.add((Component)lblTvShowsT, "cell 0 1,alignx trailing");
            if (artworkOnly) {
                this.cbTvShowScraperConfig = new ScraperMetadataConfigCheckComboBox<TvShowScraperMetadataConfig>(TvShowScraperMetadataConfig.valuesForType(ScraperMetadataConfig.Type.ARTWORK));
                this.cbTvShowScraperConfig.enableFilter((movieScraperMetadataConfig, s) -> movieScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
            } else {
                this.cbTvShowScraperConfig = new ScraperMetadataConfigCheckComboBox<TvShowScraperMetadataConfig>(TvShowScraperMetadataConfig.getValuesWithout(TvShowScraperMetadataConfig.ID));
                this.cbTvShowScraperConfig.enableFilter((tvShowScraperMetadataConfig, s) -> tvShowScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
            }
            panelScraperConfig.add(this.cbTvShowScraperConfig, "cell 1 1,grow, wmin 0");
        }
        TmmLabel lblEpisodesT = new TmmLabel(TmmResourceBundle.getString("metatag.episodes"));
        panelScraperConfig.add((Component)lblEpisodesT, "cell 0 2,alignx trailing");
        if (artworkOnly) {
            this.cbEpisodeScraperConfig = new ScraperMetadataConfigCheckComboBox<TvShowEpisodeScraperMetadataConfig>(TvShowEpisodeScraperMetadataConfig.valuesForType(ScraperMetadataConfig.Type.ARTWORK));
            this.cbEpisodeScraperConfig.enableFilter((episodeScraperMetadataConfig, s) -> episodeScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        } else {
            this.cbEpisodeScraperConfig = new ScraperMetadataConfigCheckComboBox<TvShowEpisodeScraperMetadataConfig>(TvShowEpisodeScraperMetadataConfig.getValues());
            this.cbEpisodeScraperConfig.enableFilter((episodeScraperMetadataConfig, s) -> episodeScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        }
        panelScraperConfig.add(this.cbEpisodeScraperConfig, "cell 1 2,grow, wmin 0");
        this.chckbxDoNotOverwrite = new JHintCheckBox(TmmResourceBundle.getString("message.scrape.donotoverwrite"));
        this.chckbxDoNotOverwrite.setToolTipText(TmmResourceBundle.getString("message.scrape.donotoverwrite.desc"));
        this.chckbxDoNotOverwrite.setHintIcon(IconManager.HINT);
        panelScraperConfig.add((Component)this.chckbxDoNotOverwrite, "cell 0 3 2 1");
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(TmmResourceBundle.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        if (this.cbMetadataScraper != null) {
            MediaScraper defaultScraper = TvShowModuleManager.getInstance().getTvShowList().getDefaultMediaScraper();
            this.cbMetadataScraper.setSelectedItem(defaultScraper);
        }
        if (this.cbArtworkScraper != null) {
            ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
            for (MediaScraper artworkScraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableArtworkScrapers()) {
                if (!TvShowModuleManager.getInstance().getSettings().getArtworkScrapers().contains(artworkScraper.getId())) continue;
                selectedArtworkScrapers.add(artworkScraper);
            }
            if (!selectedArtworkScrapers.isEmpty()) {
                this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
            }
        }
        if (this.cbTrailerScraper != null) {
            ArrayList<MediaScraper> selectedTrailerScrapers = new ArrayList<MediaScraper>();
            for (MediaScraper trailerScraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableTrailerScrapers()) {
                if (!TvShowModuleManager.getInstance().getSettings().getTrailerScrapers().contains(trailerScraper.getId())) continue;
                selectedTrailerScrapers.add(trailerScraper);
            }
            if (!selectedTrailerScrapers.isEmpty()) {
                this.cbTrailerScraper.setSelectedItems(selectedTrailerScrapers);
            }
        }
        if (this.cbTvShowScraperConfig != null) {
            config = new ArrayList<TvShowScraperMetadataConfig>(TvShowModuleManager.getInstance().getSettings().getTvShowScraperMetadataConfig());
            if (artworkOnly) {
                config = config.stream().filter(ScraperMetadataConfig::isArtwork).collect(Collectors.toList());
            }
            if (!TvShowModuleManager.getInstance().getSettings().isScrapeBestImage()) {
                config.removeAll(TvShowScraperMetadataConfig.valuesForType(ScraperMetadataConfig.Type.ARTWORK));
            }
            this.cbTvShowScraperConfig.setSelectedItems(config);
        }
        if (this.cbEpisodeScraperConfig != null) {
            config = new ArrayList<TvShowEpisodeScraperMetadataConfig>(TvShowModuleManager.getInstance().getSettings().getEpisodeScraperMetadataConfig());
            if (!TvShowModuleManager.getInstance().getSettings().isScrapeBestImage()) {
                config.removeAll(TvShowEpisodeScraperMetadataConfig.valuesForType(ScraperMetadataConfig.Type.ARTWORK));
            }
            this.cbEpisodeScraperConfig.setSelectedItems(config);
        }
        this.chckbxDoNotOverwrite.setSelected(TvShowModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
    }

    public void setMetadataScraper(MediaScraper metadataScraper) {
        this.cbMetadataScraper.setSelectedItem(metadataScraper);
    }

    public void setLanguage(MediaLanguages language) {
        this.cbLanguage.setSelectedItem((Object)language);
    }

    public TvShowSearchAndScrapeOptions getTvShowSearchAndScrapeOptions() {
        TvShowSearchAndScrapeOptions tvShowSearchAndScrapeConfig = new TvShowSearchAndScrapeOptions();
        tvShowSearchAndScrapeConfig.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
        tvShowSearchAndScrapeConfig.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
        tvShowSearchAndScrapeConfig.setLanguage((MediaLanguages)((Object)this.cbLanguage.getSelectedItem()));
        if (this.cbMetadataScraper != null) {
            tvShowSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        }
        if (this.cbArtworkScraper != null) {
            tvShowSearchAndScrapeConfig.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        }
        if (this.cbTrailerScraper != null) {
            tvShowSearchAndScrapeConfig.setTrailerScraper(this.cbTrailerScraper.getSelectedItems());
        }
        return tvShowSearchAndScrapeConfig;
    }

    public TvShowEpisodeSearchAndScrapeOptions getTvShowEpisodeSearchAndScrapeOptions() {
        TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
        episodeSearchAndScrapeOptions.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
        episodeSearchAndScrapeOptions.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
        episodeSearchAndScrapeOptions.setLanguage((MediaLanguages)((Object)this.cbLanguage.getSelectedItem()));
        episodeSearchAndScrapeOptions.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        episodeSearchAndScrapeOptions.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        return episodeSearchAndScrapeOptions;
    }

    public List<TvShowScraperMetadataConfig> getTvShowScraperMetadataConfig() {
        return this.cbTvShowScraperConfig.getSelectedItems();
    }

    public List<TvShowEpisodeScraperMetadataConfig> getTvShowEpisodeScraperMetadataConfig() {
        return this.cbEpisodeScraperConfig.getSelectedItems();
    }

    public boolean getOverwriteExistingItems() {
        return !this.chckbxDoNotOverwrite.isSelected();
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }

    public static TvShowScrapeMetadataDialog createArtworkScrapeDialog(String title) {
        return new TvShowScrapeMetadataDialog(title, true, true);
    }

    public static TvShowScrapeMetadataDialog createScrapeDialog(String title) {
        return new TvShowScrapeMetadataDialog(title, false, true);
    }

    public static TvShowScrapeMetadataDialog createEpisodeScrapeDialog(String title) {
        return new TvShowScrapeMetadataDialog(title, false, false);
    }
}

