/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowSeasonEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3270218410302989845L;
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String SPACER = "        ";
    private final TvShowSeason tvShowSeasonToEdit;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final JTabbedPane tabbedPane = new TmmTabbedPane();
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private final int queueIndex;
    private final int queueSize;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private ImageLabel lblBanner;
    private ImageLabel lblThumb;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfBanner;
    private JTextField tfThumb;
    private JTextField tfTitle;

    public TvShowSeasonEditorDialog(TvShowSeason tvShowSeason, int queueIndex, int queueSize, int selectedTab) {
        super(TmmResourceBundle.getString("tvshowseason.edit") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "tvShowSeasonEditor");
        this.tvShowSeasonToEdit = tvShowSeason;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.initComponents();
        this.tfTitle.setText(tvShowSeason.getTitle());
        this.lblPoster.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        this.lblFanart.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_FANART));
        this.lblThumb.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB));
        this.lblBanner.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER));
        this.tfPoster.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        this.tfFanart.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_FANART));
        this.tfThumb.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_THUMB));
        this.tfBanner.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_BANNER));
        this.tabbedPane.setSelectedIndex(selectedTab);
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    private void initComponents() {
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(this.tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[150lp:200lp,grow][20lp:n][300lp:400lp,grow][20lp:n][300lp:400lp,grow]", "[][][100lp:125lp,grow][20lp:n][][100lp:125lp,grow][]"));
        TmmLabel lblTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        artworkPanel.add((Component)lblTitleT, "flowx,cell 0 0 5 1");
        this.tfTitle = new JTextField();
        this.tfTitle.setColumns(10);
        artworkPanel.add((Component)this.tfTitle, "cell 0 0 5 1,growx");
        TmmLabel lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 1");
        LinkLabel lblPosterSize = new LinkLabel();
        artworkPanel.add((Component)lblPosterSize, "cell 0 1");
        FlatButton btnDeletePoster = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        artworkPanel.add((Component)btnDeletePoster, "cell 0 1");
        this.lblPoster = new ImageLabel();
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblPoster, TvShowSeasonEditorDialog.this.tfPoster, MediaArtwork.MediaArtworkType.SEASON_POSTER);
            }
        });
        artworkPanel.add((Component)this.lblPoster, "cell 0 2,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, MediaArtwork.MediaArtworkType.SEASON_POSTER));
        TmmLabel lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkPanel.add((Component)lblFanartT, "cell 2 1");
        LinkLabel lblFanartSize = new LinkLabel();
        artworkPanel.add((Component)lblFanartSize, "cell 2 1");
        FlatButton btnDeleteFanart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        artworkPanel.add((Component)btnDeleteFanart, "cell 2 1");
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblFanart, TvShowSeasonEditorDialog.this.tfFanart, MediaArtwork.MediaArtworkType.SEASON_FANART);
            }
        });
        artworkPanel.add((Component)this.lblFanart, "cell 2 2,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, MediaArtwork.MediaArtworkType.SEASON_FANART));
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 4 1");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 4 1");
        FlatButton btnDeleteThumb = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 4 1");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblThumb, TvShowSeasonEditorDialog.this.tfThumb, MediaArtwork.MediaArtworkType.SEASON_THUMB);
            }
        });
        artworkPanel.add((Component)this.lblThumb, "cell 4 2,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, MediaArtwork.MediaArtworkType.SEASON_THUMB));
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 4");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 0 4");
        FlatButton btnDeleteBanner = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 0 4");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblBanner, TvShowSeasonEditorDialog.this.tfBanner, MediaArtwork.MediaArtworkType.SEASON_BANNER);
            }
        });
        artworkPanel.add((Component)this.lblBanner, "cell 0 5 5 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, MediaArtwork.MediaArtworkType.SEASON_BANNER));
        artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("edit.artwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][]"));
        lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 2,alignx right");
        this.tfBanner = new JTextField();
        artworkPanel.add((Component)this.tfBanner, "cell 1 2,growx");
        lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 3,alignx right");
        this.tfThumb = new JTextField();
        artworkPanel.add((Component)this.tfThumb, "cell 1 3,growx");
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbortAction());
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new OKAction());
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void openImageChooser(ImageLabel label, JTextField textField, MediaArtwork.MediaArtworkType artworkType) {
        HashMap<String, Object> ids = new HashMap<String, Object>(this.tvShowSeasonToEdit.getTvShow().getIds());
        ids.put("tvShowSeason", this.tvShowSeasonToEdit.getSeason());
        ImageChooserDialog dialog = new ImageChooserDialog(this, ids, artworkType, this.tvShowList.getDefaultArtworkScrapers(), label, MediaType.TV_SHOW);
        if (Settings.getInstance().isImageChooserUseEntityFolder()) {
            TvShow tvShow = this.tvShowSeasonToEdit.getTvShow();
            Path seasonPath = tvShow.getPathNIO().resolve(TvShowHelpers.detectSeasonFolder(tvShow, this.tvShowSeasonToEdit.getSeason())).toAbsolutePath();
            if (!Files.exists(seasonPath, new LinkOption[0])) {
                seasonPath = tvShow.getPathNIO().toAbsolutePath();
            }
            dialog.setOpenFolderPath(seasonPath.toString());
        }
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        this.updateArtworkUrl(label, textField);
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, MediaArtwork.MediaArtworkType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        if (imageLabel.getOriginalImageSize().width == 0 && imageLabel.getOriginalImageSize().height == 0) {
            lblSize.setText("");
            return;
        }
        Dimension dimension = this.tvShowSeasonToEdit.getArtworkSize(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        MediaArtwork.MediaArtworkType artworkType = MediaFileType.getMediaArtworkType(type);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.tvShowSeasonToEdit.getArtworkFilename(artworkType))) {
            this.tvShowSeasonToEdit.deleteArtworkFiles(artworkType);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.tvShowSeasonToEdit.getArtworkUrl(artworkType))) {
            this.tvShowSeasonToEdit.setArtworkUrl(textField.getText(), artworkType);
            this.tvShowSeasonToEdit.downloadArtwork(artworkType);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.tvShowSeasonToEdit.removeArtworkUrl(artworkType);
        } else if (StringUtils.isBlank((CharSequence)this.tvShowSeasonToEdit.getArtworkFilename(artworkType))) {
            this.tvShowSeasonToEdit.downloadArtwork(artworkType);
        }
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        AbortAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.abortqueue"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.continueQueue = false;
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.navigateBack = true;
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -4617793684152607277L;

        CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 6699599213348390696L;

        OKAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setTitle(TvShowSeasonEditorDialog.this.tfTitle.getText());
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_POSTER, TvShowSeasonEditorDialog.this.lblPoster, TvShowSeasonEditorDialog.this.tfPoster);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_FANART, TvShowSeasonEditorDialog.this.lblFanart, TvShowSeasonEditorDialog.this.tfFanart);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_BANNER, TvShowSeasonEditorDialog.this.lblBanner, TvShowSeasonEditorDialog.this.tfBanner);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_THUMB, TvShowSeasonEditorDialog.this.lblThumb, TvShowSeasonEditorDialog.this.tfThumb);
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().writeNFO();
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().saveToDb();
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }
}

