/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowMissingArtworkFilter
extends AbstractCheckComboBoxTvShowUIFilter<MetadataField> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowMissingArtworkFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        ArrayList<MetadataField> values = new ArrayList<MetadataField>();
        for (TvShowScraperMetadataConfig config : TvShowScraperMetadataConfig.values()) {
            if (!config.isArtwork()) continue;
            values.add(new MetadataField(config));
            if (config != TvShowScraperMetadataConfig.THUMB) continue;
            values.add(new MetadataField(config, true));
        }
        this.setValues(values);
    }

    @Override
    public String getId() {
        return "tvShowMissingArtwork";
    }

    @Override
    protected String parseTypeToString(MetadataField type) throws Exception {
        if (type.episode) {
            return "EPISODE_" + type.config.name();
        }
        return type.config.name();
    }

    @Override
    protected MetadataField parseStringToType(String string) throws Exception {
        try {
            if (string.startsWith("EPISODE_")) {
                return new MetadataField(TvShowScraperMetadataConfig.valueOf(string.replace("EPISODE_", "")), true);
            }
            return new MetadataField(TvShowScraperMetadataConfig.valueOf(string));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        ArrayList<TvShowScraperMetadataConfig> tvShowValues = new ArrayList<TvShowScraperMetadataConfig>();
        ArrayList<TvShowEpisodeScraperMetadataConfig> episodeValues = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (MetadataField metadataField : this.checkComboBox.getSelectedItems()) {
            if (!metadataField.episode) {
                tvShowValues.add(metadataField.config);
                continue;
            }
            if (metadataField.config != TvShowScraperMetadataConfig.THUMB) continue;
            episodeValues.add(TvShowEpisodeScraperMetadataConfig.THUMB);
        }
        if (invert ^ !this.tvShowList.detectMissingFields(tvShow, tvShowValues).isEmpty()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (episode.isDummy() || !(invert ^ !this.tvShowList.detectMissingFields(episode, episodeValues).isEmpty())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.missingartwork"));
    }

    public static class MetadataField {
        private final TvShowScraperMetadataConfig config;
        private final boolean episode;

        MetadataField(TvShowScraperMetadataConfig config) {
            this(config, false);
        }

        MetadataField(TvShowScraperMetadataConfig config, boolean episode) {
            this.config = config;
            this.episode = episode;
        }

        public String toString() {
            Object description = this.config.getDescription();
            if (this.episode) {
                description = (String)description + " (" + TmmResourceBundle.getString("mediafiletype.episode") + ")";
            }
            return description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataField that = (MetadataField)o;
            return this.episode == that.episode && this.config == that.config;
        }

        public int hashCode() {
            return Objects.hash(this.config, this.episode);
        }
    }
}

