/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowSubtitleLanguageFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowSubtitleLanguageFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildSubtitleLanguageArray();
        this.tvShowList.addPropertyChangeListener("subtitleLanguages", evt -> SwingUtilities.invokeLater(this::buildSubtitleLanguageArray));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE);
            for (MediaFile mf : mfs) {
                if (invert ^ (selectedItems.isEmpty() && mf.getSubtitleLanguagesList().isEmpty())) {
                    return true;
                }
                for (String lang : mf.getSubtitleLanguagesList()) {
                    if (!(invert ^ selectedItems.contains(lang))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitlelanguage"));
    }

    @Override
    public String getId() {
        return "tvShowSubtitleLanguage";
    }

    private void buildSubtitleLanguageArray() {
        ArrayList<String> subtitles = new ArrayList<String>(this.tvShowList.getSubtitleLanguagesInEpisodes());
        Collections.sort(subtitles);
        this.setValues(subtitles);
    }
}

