/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTextTvShowUIFilter;

public class TvShowVideoFilenameFilter
extends AbstractTextTvShowUIFilter {
    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = false;
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(episode.getOriginalFilename()));
                if (matcher.find()) {
                    foundEpisode = true;
                } else {
                    for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.VIDEO)) {
                        matcher = this.filterPattern.matcher(StrgUtils.normalizeString(mediaFile.getFilename()));
                        if (!matcher.find()) continue;
                        foundEpisode = true;
                        break;
                    }
                }
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.videofilename"));
    }

    @Override
    public String getId() {
        return "tvShowVideoFilename";
    }
}

