/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.ITmmTabItem;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.actions.ClearFilterPresetAction;
import org.tinymediamanager.ui.actions.FilterPresetAction;
import org.tinymediamanager.ui.actions.RequestFocusAction;
import org.tinymediamanager.ui.components.SplitButton;
import org.tinymediamanager.ui.components.TmmListPanel;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeModel;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableComparatorChooser;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowTableFormat;
import org.tinymediamanager.ui.tvshows.TvShowTreeCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowTreeDataProvider;
import org.tinymediamanager.ui.tvshows.TvShowTreeTextFilter;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.actions.TvShowEditAction;

public class TvShowTreePanel
extends TmmListPanel
implements ITmmTabItem {
    private static final long serialVersionUID = 5889203009864512935L;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final TvShowSelectionModel selectionModel;
    private TmmTreeTable tree;
    private JLabel lblEpisodeCountFiltered;
    private JLabel lblEpisodeCountTotal;
    private JLabel lblTvShowCountFiltered;
    private JLabel lblTvShowCountTotal;
    private SplitButton btnFilter;
    private JLabel lblSelectedEpisodeCount;
    private JPopupMenu popupMenu;
    private Timer totalCalculationTimer = null;

    public TvShowTreePanel(TvShowSelectionModel selectionModel) {
        this.initComponents();
        this.selectionModel = selectionModel;
        this.selectionModel.setTreeTable(this.tree);
        this.updateTotals();
        this.tvShowList.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "tvShowCount": 
                case "episodeCount": {
                    this.updateTotals();
                    break;
                }
            }
        });
        TvShowModuleManager.getInstance().getSettings().addPropertyChangeListener(e -> {
            switch (e.getPropertyName()) {
                case "tvShowCheckMetadata": 
                case "tvShowCheckArtwork": 
                case "seasonCheckArtwork": 
                case "episodeCheckMetadata": 
                case "episodeCheckArtwork": 
                case "episodeSpecialsCheckMissingMetadata": 
                case "episodeSpecialsCheckMissingArtwork": {
                    this.tree.invalidate();
                    break;
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[200lp:n,grow][100lp:n,fill]", "[][200lp:n,grow]0[][][]"));
        TvShowTreeTextFilter<TmmTreeNode> searchField = new TvShowTreeTextFilter<TmmTreeNode>();
        this.add(searchField, "cell 0 0,growx");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(70, 128), "search");
        this.getActionMap().put("search", new RequestFocusAction(searchField));
        this.btnFilter = new SplitButton(TmmResourceBundle.getString("movieextendedsearch.filter"));
        this.btnFilter.setToolTipText(TmmResourceBundle.getString("movieextendedsearch.options"));
        this.btnFilter.getActionButton().addActionListener(e -> TvShowUIModule.getInstance().setFilterDialogVisible(true));
        this.btnFilter.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JPopupMenu popupMenu = TvShowTreePanel.this.btnFilter.getPopupMenu();
                popupMenu.removeAll();
                TvShowModuleManager.getInstance().getSettings().getUiFilterPresets().keySet().stream().sorted().forEach(uiFilter -> {
                    FilterPresetAction action = new FilterPresetAction((String)uiFilter){

                        @Override
                        protected void processAction(ActionEvent e) {
                            TvShowTreePanel.this.tree.setFilterValues(TvShowModuleManager.getInstance().getSettings().getUiFilterPresets().get(this.presetName));
                            TvShowTreePanel.this.tree.storeFilters();
                        }
                    };
                    popupMenu.add(action);
                });
                if (popupMenu.getSubElements().length != 0) {
                    popupMenu.addSeparator();
                }
                popupMenu.add(new ClearFilterPresetAction(){

                    @Override
                    protected void processAction(ActionEvent e) {
                        TvShowTreePanel.this.tree.setFilterValues(Collections.emptyList());
                        TvShowTreePanel.this.tree.storeFilters();
                    }
                });
                popupMenu.pack();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.add((Component)this.btnFilter, "cell 1 0");
        TvShowTableFormat tableFormat = new TvShowTableFormat();
        this.tree = new TmmTreeTable(new TvShowTreeDataProvider(tableFormat), tableFormat){

            @Override
            public void storeFilters() {
                if (TvShowModuleManager.getInstance().getSettings().isStoreUiFilters()) {
                    ArrayList<AbstractSettings.UIFilters> filterValues = new ArrayList<AbstractSettings.UIFilters>();
                    if (this.isFiltersActive()) {
                        for (ITmmTreeFilter filter : this.treeFilters) {
                            ITmmUIFilter uiFilter;
                            if (!(filter instanceof ITmmUIFilter) || (uiFilter = (ITmmUIFilter)((Object)filter)).getFilterState() == ITmmUIFilter.FilterState.INACTIVE) continue;
                            AbstractSettings.UIFilters uiFilters = new AbstractSettings.UIFilters();
                            uiFilters.id = uiFilter.getId();
                            uiFilters.state = uiFilter.getFilterState();
                            uiFilters.filterValue = uiFilter.getFilterValueAsString();
                            filterValues.add(uiFilters);
                        }
                    }
                    TvShowModuleManager.getInstance().getSettings().setUiFilters(filterValues);
                    TvShowModuleManager.getInstance().getSettings().saveSettings();
                }
            }
        };
        this.tree.getColumnModel().getColumn(0).setCellRenderer(new TvShowTreeCellRenderer());
        this.tree.addPropertyChangeListener("filterChanged", evt -> this.updateFilterIndicator());
        this.tree.setName("tvshows.tvshowTree");
        TmmUILayoutStore.getInstance().install(this.tree);
        TmmTreeTableComparatorChooser.install(this.tree);
        this.tree.addFilter(searchField);
        JScrollPane scrollPane = new JScrollPane();
        this.tree.configureScrollPane(scrollPane);
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.tree.adjustColumnPreferredWidths(3);
        this.tree.setRootVisible(false);
        this.tree.getModel().addTableModelListener(arg0 -> {
            this.updateTotals();
            if (this.tree.getTreeTableModel().getTreeModel() instanceof TmmTreeModel && ((TmmTreeModel)this.tree.getTreeTableModel().getTreeModel()).isAdjusting()) {
                return;
            }
            ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
            if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                selectionModel1.setSelectionInterval(0, 0);
            } else if (this.tree.getModel().getRowCount() == 0) {
                TvShowUIModule.getInstance().setSelectedTvShow(null);
            }
        });
        this.tree.getSelectionModel().addListSelectionListener(arg0 -> {
            if (arg0.getValueIsAdjusting() || !(arg0.getSource() instanceof DefaultListSelectionModel)) {
                return;
            }
            if (this.tree.getModel().getRowCount() == 0) {
                TvShowUIModule.getInstance().setSelectedTvShow(null);
                return;
            }
            int index = ((DefaultListSelectionModel)arg0.getSource()).getMinSelectionIndex();
            DefaultMutableTreeNode node = this.tree.getTreeNode(index);
            if (node != null) {
                if (node.getUserObject() instanceof TvShow) {
                    TvShow tvShow = (TvShow)node.getUserObject();
                    TvShowUIModule.getInstance().setSelectedTvShow(tvShow);
                }
                if (node.getUserObject() instanceof TvShowSeason) {
                    TvShowSeason tvShowSeason = (TvShowSeason)node.getUserObject();
                    TvShowUIModule.getInstance().setSelectedTvShowSeason(tvShowSeason);
                }
                if (node.getUserObject() instanceof TvShowEpisode) {
                    TvShowEpisode tvShowEpisode = (TvShowEpisode)node.getUserObject();
                    TvShowUIModule.getInstance().setSelectedTvShowEpisode(tvShowEpisode);
                }
            } else {
                TvShowUIModule.getInstance().setSelectedTvShow(null);
            }
            this.updateSelectionSums();
        });
        if (this.tvShowList.getTvShows() != null && !this.tvShowList.getTvShows().isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
                if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                    selectionModel1.setSelectionInterval(0, 0);
                }
            });
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed() && e.getButton() == 1) {
                    new TvShowEditAction().actionPerformed(new ActionEvent(e, 0, ""));
                }
            }
        };
        this.tree.addMouseListener(mouseListener);
        InputMap inputMap = this.tree.getInputMap(0);
        ActionMap actionMap = this.tree.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(525, 0), "popup");
        actionMap.put("popup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TvShowTreePanel.this.popupMenu != null) {
                    Rectangle rect = TvShowTreePanel.this.tree.getCellRect(TvShowTreePanel.this.tree.getSelectedRow(), 0, false);
                    TvShowTreePanel.this.popupMenu.show(TvShowTreePanel.this.tree, rect.x + rect.width / 2, rect.y + rect.height / 2);
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){
            private long lastKeypress = 0L;
            private String searchTerm = "";

            @Override
            public void keyTyped(KeyEvent e) {
                long now = System.currentTimeMillis();
                if (now - this.lastKeypress > 500L) {
                    this.searchTerm = "";
                }
                this.lastKeypress = now;
                if (e.getKeyChar() != '\uffff') {
                    this.searchTerm = this.searchTerm + e.getKeyChar();
                    this.searchTerm = this.searchTerm.toLowerCase();
                }
                if (StringUtils.isNotBlank((CharSequence)this.searchTerm)) {
                    TableModel model = TvShowTreePanel.this.tree.getModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        TvShowTreeDataProvider.TvShowTreeNode node;
                        String title;
                        if (!(model.getValueAt(i, 0) instanceof TvShowTreeDataProvider.TvShowTreeNode) || !(title = (node = (TvShowTreeDataProvider.TvShowTreeNode)model.getValueAt(i, 0)).toString().toLowerCase(Locale.ROOT)).startsWith(this.searchTerm)) continue;
                        TvShowTreePanel.this.tree.getSelectionModel().setSelectionInterval(i, i);
                        TvShowTreePanel.this.tree.scrollRectToVisible(new Rectangle(TvShowTreePanel.this.tree.getCellRect(i, 0, true)));
                        break;
                    }
                }
            }
        };
        this.tree.addKeyListener(keyListener);
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 2 2 1,growx");
        JPanel panelTotals = new JPanel();
        this.add((Component)panelTotals, "cell 0 3 2 1,grow");
        panelTotals.setLayout((LayoutManager)new MigLayout("insets 0", "[100lp:n,grow][100lp:n,grow,right]", "[]"));
        JLabel lblTvShowCount = new JLabel(TmmResourceBundle.getString("tmm.tvshows") + ":");
        panelTotals.add((Component)lblTvShowCount, "flowx,cell 0 0");
        this.lblTvShowCountFiltered = new JLabel("");
        panelTotals.add((Component)this.lblTvShowCountFiltered, "cell 0 0");
        JLabel lblTvShowCountOf = new JLabel(TmmResourceBundle.getString("tmm.of"));
        panelTotals.add((Component)lblTvShowCountOf, "cell 0 0");
        this.lblTvShowCountTotal = new JLabel("");
        panelTotals.add((Component)this.lblTvShowCountTotal, "cell 0 0");
        JLabel lblEpisodeCount = new JLabel(TmmResourceBundle.getString("metatag.episodes") + ":");
        panelTotals.add((Component)lblEpisodeCount, "flowx,cell 0 1");
        this.lblEpisodeCountFiltered = new JLabel("");
        panelTotals.add((Component)this.lblEpisodeCountFiltered, "cell 0 1");
        JLabel lblEpisodeCountOf = new JLabel(TmmResourceBundle.getString("tmm.of"));
        panelTotals.add((Component)lblEpisodeCountOf, "cell 0 1");
        this.lblEpisodeCountTotal = new JLabel("");
        panelTotals.add((Component)this.lblEpisodeCountTotal, "cell 0 1");
        this.lblSelectedEpisodeCount = new JLabel("");
        panelTotals.add((Component)this.lblSelectedEpisodeCount, "cell 1 1");
    }

    private void updateFilterIndicator() {
        boolean active = false;
        if (this.tree.isFiltersActive()) {
            for (ITmmTreeFilter<TmmTreeNode> filter : this.tree.getFilters()) {
                if (!(filter instanceof ITmmUIFilter)) continue;
                ITmmUIFilter uiFilter = (ITmmUIFilter)((Object)filter);
                switch (uiFilter.getFilterState()) {
                    case ACTIVE: 
                    case ACTIVE_NEGATIVE: {
                        active = true;
                        break;
                    }
                }
                if (!active) continue;
                break;
            }
        }
        if (active) {
            this.btnFilter.getActionButton().setIcon(IconManager.FILTER_ACTIVE);
        } else {
            this.btnFilter.getActionButton().setIcon(null);
        }
    }

    private void updateTotals() {
        if (this.totalCalculationTimer != null) {
            return;
        }
        this.totalCalculationTimer = new Timer("updateTotals");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> {
                    TvShowTreePanel.this.lblTvShowCountTotal.setText(String.valueOf(TvShowTreePanel.this.tvShowList.getTvShowCount()));
                    int dummyEpisodeCount = 0;
                    if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
                        dummyEpisodeCount = TvShowTreePanel.this.tvShowList.getDummyEpisodeCount();
                    }
                    if (dummyEpisodeCount > 0) {
                        int episodeCount = TvShowTreePanel.this.tvShowList.getEpisodeCount();
                        TvShowTreePanel.this.lblEpisodeCountTotal.setText(episodeCount + " (" + (episodeCount + dummyEpisodeCount) + ")");
                    } else {
                        TvShowTreePanel.this.lblEpisodeCountTotal.setText(String.valueOf(TvShowTreePanel.this.tvShowList.getEpisodeCount()));
                    }
                    int tvShowCount = 0;
                    int episodeCount = 0;
                    int virtualEpisodeCount = 0;
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)TvShowTreePanel.this.tree.getTreeTableModel().getRoot();
                    Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
                    while (enumeration.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                        Object userObject = node.getUserObject();
                        if (userObject instanceof TvShow) {
                            ++tvShowCount;
                            continue;
                        }
                        if (!(userObject instanceof TvShowEpisode)) continue;
                        if (((TvShowEpisode)userObject).isDummy()) {
                            ++virtualEpisodeCount;
                            continue;
                        }
                        ++episodeCount;
                    }
                    TvShowTreePanel.this.lblTvShowCountFiltered.setText(String.valueOf(tvShowCount));
                    if (TvShowTreePanel.this.tvShowList.hasDummyEpisodes()) {
                        TvShowTreePanel.this.lblEpisodeCountFiltered.setText(episodeCount + " (" + (episodeCount + virtualEpisodeCount) + ")");
                    } else {
                        TvShowTreePanel.this.lblEpisodeCountFiltered.setText(String.valueOf(episodeCount));
                    }
                    TvShowTreePanel.this.totalCalculationTimer = null;
                });
            }
        };
        this.totalCalculationTimer.schedule(task, 100L);
    }

    private void updateSelectionSums() {
        List<TvShowEpisode> episodes = this.selectionModel.getSelectedEpisodes(true);
        String selectedEpisodes = TmmResourceBundle.getString("episode.selected").replace("{}", String.valueOf(episodes.size()));
        double videoFileSize = (double)episodes.stream().mapToLong(TvShowEpisode::getVideoFilesize).sum() / 1.0E9;
        double totalFileSize = (double)episodes.stream().mapToLong(MediaEntity::getTotalFilesize).sum() / 1.0E9;
        String text = String.format("%s (%.2f G)", selectedEpisodes, totalFileSize);
        this.lblSelectedEpisodeCount.setText(text);
        String selectedEpisodesHint = selectedEpisodes + " (" + TmmResourceBundle.getString("tmm.selected.hint1").replace("{}", String.format("%.2f G", videoFileSize)) + " / " + TmmResourceBundle.getString("tmm.selected.hint2").replace("{}", String.format("%.2f G", totalFileSize)) + ")";
        this.lblSelectedEpisodeCount.setToolTipText(selectedEpisodesHint);
    }

    @Override
    public ITmmUIModule getUIModule() {
        return TvShowUIModule.getInstance();
    }

    public TmmTreeTable getTreeTable() {
        return this.tree;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        popupMenu.addSeparator();
        popupMenu.add(new ExpandAllAction());
        popupMenu.add(new CollapseAllAction());
        this.tree.addMouseListener(new TablePopupListener(popupMenu, this.tree));
    }

    public class ExpandAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 6191727607109012198L;

        public ExpandAllAction() {
            this.putValue("Name", TmmResourceBundle.getString("tree.expandall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            do {
                TvShowTreePanel.this.tree.expandRow(i++);
            } while (i < TvShowTreePanel.this.tree.getRowCount());
        }
    }

    public class CollapseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1444530142931061317L;

        public CollapseAllAction() {
            this.putValue("Name", TmmResourceBundle.getString("tree.collapseall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = TvShowTreePanel.this.tree.getRowCount() - 1; i >= 0; --i) {
                TvShowTreePanel.this.tree.collapseRow(i);
            }
        }
    }
}

