/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.season;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.InformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowSeasonSelectionModel;

public class TvShowSeasonInformationPanel
extends InformationPanel {
    private static final long serialVersionUID = 1911808562993073590L;
    private static final String LAYOUT_ARTWORK_VISIBLE = "[n:100lp:20%, grow][300lp:300lp,grow 350]";
    private static final String LAYOUT_ARTWORK_HIDDEN = "[][300lp:300lp,grow 350]";
    private Color defaultColor;
    private Color dummyColor;
    private final EventList<TvShowEpisode> episodeEventList;
    private final TmmTableModel<TvShowEpisode> episodeTableModel;
    private final TvShowSeasonSelectionModel tvShowSeasonSelectionModel;
    private JLabel lblTvshowTitle;
    private JLabel lblSeason;
    private TmmTable tableEpisodes;

    public TvShowSeasonInformationPanel(TvShowSeasonSelectionModel tvShowSeasonSelectionModel) {
        this.tvShowSeasonSelectionModel = tvShowSeasonSelectionModel;
        this.episodeEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShowEpisode.class));
        this.episodeTableModel = new TmmTableModel<TvShowEpisode>((EventList<TvShowEpisode>)GlazedListsSwing.swingThreadProxyList(this.episodeEventList), new EpisodeTableFormat());
        this.initComponents();
        this.initDataBindings();
        this.tableEpisodes.setDefaultRenderer(String.class, new EpisodeTableCellRenderer());
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSeasonSelectionModel.class) {
                return;
            }
            TvShowSeasonSelectionModel model = (TvShowSeasonSelectionModel)source;
            TvShowSeason selectedSeason = model.getSelectedTvShowSeason();
            if ("selectedTvShowSeason".equals(property) || "poster".equals(property)) {
                this.setPoster(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "fanart".equals(property)) {
                this.setFanart(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "banner".equals(property)) {
                this.setBanner(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "thumb".equals(property)) {
                this.setThumb(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "mediaFiles".equals(property) || "addedEpisode".equals(property) || "removedEpisode".equals(property)) {
                try {
                    this.episodeEventList.getReadWriteLock().writeLock().lock();
                    this.episodeEventList.clear();
                    this.episodeEventList.addAll(selectedSeason.getEpisodesForDisplay());
                }
                catch (Exception exception) {
                }
                finally {
                    this.episodeEventList.getReadWriteLock().writeLock().unlock();
                    this.tableEpisodes.adjustColumnPreferredWidths(6);
                }
            }
        };
        tvShowSeasonSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.defaultColor = UIManager.getColor("Table.foreground");
        this.dummyColor = UIManager.getColor("Component.linkColor");
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", LAYOUT_ARTWORK_VISIBLE, "[grow]"));
        JPanel panelLeft = new JPanel();
        this.add((Component)panelLeft, "cell 0 0,grow");
        panelLeft.setLayout(new ColumnLayout());
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_POSTER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_FANART)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_BANNER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_THUMB)) {
            panelLeft.add(component);
        }
        JPanel panelRight = new JPanel();
        this.add((Component)panelRight, "cell 1 0,grow");
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[][323px,grow]", "[][][shrink 0][][286px,grow]"));
        this.lblTvshowTitle = new TmmLabel("", 1.33);
        panelRight.add((Component)this.lblTvshowTitle, "cell 0 0 2 1");
        TmmLabel lblSeasonT = new TmmLabel(TmmResourceBundle.getString("metatag.season"));
        panelRight.add((Component)lblSeasonT, "cell 0 1");
        TmmFontHelper.changeFont(lblSeasonT, 1.166, 1);
        this.lblSeason = new JLabel("");
        panelRight.add((Component)this.lblSeason, "cell 1 1");
        TmmFontHelper.changeFont(this.lblSeason, 1.166, 1);
        panelRight.add((Component)new JSeparator(), "cell 0 2 2 1,growx");
        TmmLabel lblEpisodelistT = new TmmLabel(TmmResourceBundle.getString("metatag.episodes"));
        panelRight.add((Component)lblEpisodelistT, "cell 0 3 2 1");
        this.tableEpisodes = new TmmTable((TableModel)((Object)this.episodeTableModel));
        this.tableEpisodes.setName("tvshows.seaon.episodeTable");
        TmmUILayoutStore.getInstance().install(this.tableEpisodes);
        JScrollPane scrollPaneEpisodes = new JScrollPane();
        this.tableEpisodes.configureScrollPane(scrollPaneEpisodes);
        panelRight.add((Component)scrollPaneEpisodes, "cell 0 4 2 1,grow");
        scrollPaneEpisodes.setViewportView(this.tableEpisodes);
    }

    private void setPoster(TvShowSeason season) {
        String posterPath = season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        Dimension posterSize = season.getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        if (StringUtils.isBlank((CharSequence)posterPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            posterPath = season.getTvShow().getArtworkFilename(MediaFileType.POSTER);
            posterSize = season.getTvShow().getArtworkDimension(MediaFileType.POSTER);
        }
        this.setArtwork(MediaFileType.SEASON_POSTER, posterPath, posterSize);
    }

    private void setFanart(TvShowSeason season) {
        String fanartPath = season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_FANART);
        Dimension fanartSize = season.getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_FANART);
        if (StringUtils.isBlank((CharSequence)fanartPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            fanartPath = season.getTvShow().getArtworkFilename(MediaFileType.FANART);
            fanartSize = season.getTvShow().getArtworkDimension(MediaFileType.FANART);
        }
        this.setArtwork(MediaFileType.SEASON_FANART, fanartPath, fanartSize);
    }

    private void setBanner(TvShowSeason season) {
        String bannerPath = season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER);
        Dimension bannerSize = season.getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_BANNER);
        if (StringUtils.isBlank((CharSequence)bannerPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            bannerPath = season.getTvShow().getArtworkFilename(MediaFileType.BANNER);
            bannerSize = season.getTvShow().getArtworkDimension(MediaFileType.BANNER);
        }
        this.setArtwork(MediaFileType.SEASON_BANNER, bannerPath, bannerSize);
    }

    private void setThumb(TvShowSeason season) {
        String thumbPath = season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB);
        Dimension thumbSize = season.getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_THUMB);
        if (StringUtils.isBlank((CharSequence)thumbPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            thumbPath = season.getTvShow().getArtworkFilename(MediaFileType.FANART);
            thumbSize = season.getTvShow().getArtworkDimension(MediaFileType.FANART);
        }
        this.setArtwork(MediaFileType.SEASON_THUMB, thumbPath, thumbSize);
    }

    private void setArtwork(MediaFileType type, String artworkPath, Dimension artworkDimension) {
        List components = (List)this.artworkComponents.get((Object)type);
        if (ListUtils.isEmpty(components)) {
            return;
        }
        boolean visible = this.getShowArtworkFromSettings().contains((Object)type);
        for (Component component : components) {
            component.setVisible(visible);
            if (component instanceof ImageLabel) {
                ImageLabel imageLabel = (ImageLabel)component;
                imageLabel.clearImage();
                imageLabel.setImagePath(artworkPath);
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            JLabel sizeLabel = (JLabel)component;
            if (artworkDimension.width > 0 && artworkDimension.height > 0) {
                sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)) + " - " + artworkDimension.width + "x" + artworkDimension.height);
                continue;
            }
            sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)));
        }
        this.updateArtwork();
    }

    @Override
    protected List<MediaFileType> getShowArtworkFromSettings() {
        return TvShowModuleManager.getInstance().getSettings().getShowSeasonArtworkTypes();
    }

    @Override
    protected void setColumnLayout(boolean artworkVisible) {
        if (artworkVisible) {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_VISIBLE);
        } else {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_HIDDEN);
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSeasonSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowSeason.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty, (Object)this.lblTvshowTitle, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSeasonSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowSeason.season");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty_1, (Object)this.lblSeason, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }

    private class EpisodeTableCellRenderer
    extends DefaultTableCellRenderer {
        private EpisodeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int dataRow = table.convertRowIndexToModel(row);
            if (((TvShowEpisode)TvShowSeasonInformationPanel.this.episodeEventList.get(dataRow)).isDummy()) {
                c.setForeground(TvShowSeasonInformationPanel.this.dummyColor);
            } else {
                c.setForeground(TvShowSeasonInformationPanel.this.defaultColor);
            }
            return c;
        }
    }

    private static class EpisodeTableFormat
    extends TmmTableFormat<TvShowEpisode> {
        public EpisodeTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode"), "episode", TvShowEpisode::getEpisode, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", MediaEntity::getTitle, String.class);
            col.setColumnTooltip(MediaEntity::getTitle);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aired"), "aired", TvShowEpisode::getFirstAiredAsString, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
        }
    }
}

