/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.ActorImageLabel;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowCastPanel
extends JPanel {
    private static final long serialVersionUID = 2374973082749248956L;
    private final TvShowSelectionModel selectionModel;
    private EventList<Person> actorEventList = null;
    private TmmTable tableActors;
    private ActorImageLabel lblActorImage;

    public TvShowCastPanel(TvShowSelectionModel model) {
        this.selectionModel = model;
        this.actorEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(Person.class)));
        this.initComponents();
        this.lblActorImage.enableLightbox();
        this.lblActorImage.setCacheUrl(true);
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSelectionModel.class) {
                return;
            }
            if ("selectedTvShow".equals(property) || "actors".equals(property)) {
                this.actorEventList.clear();
                this.actorEventList.addAll(this.selectionModel.getSelectedTvShow().getActors());
                if (!this.actorEventList.isEmpty()) {
                    this.tableActors.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.tableActors.getSelectionModel().addListSelectionListener(arg0 -> {
            if (!arg0.getValueIsAdjusting()) {
                int selectedRow = this.tableActors.convertRowIndexToModel(this.tableActors.getSelectedRow());
                if (selectedRow >= 0 && selectedRow < this.actorEventList.size()) {
                    Person actor = (Person)this.actorEventList.get(selectedRow);
                    this.lblActorImage.setActor(this.selectionModel.getSelectedTvShow(), actor);
                } else {
                    this.lblActorImage.clearImage();
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][400lp,grow][150lp,grow]", "[200lp,grow][grow]"));
        TmmLabel lblActorsT = new TmmLabel(TmmResourceBundle.getString("metatag.actors"));
        TmmFontHelper.changeFont((JComponent)lblActorsT, 1);
        this.add((Component)lblActorsT, "cell 0 0,aligny top");
        this.lblActorImage = new ActorImageLabel();
        this.add((Component)this.lblActorImage, "cell 2 0,grow");
        this.tableActors = new PersonTable(this.actorEventList){

            @Override
            public void onPersonChanged(Person person) {
                super.onPersonChanged(person);
                TvShowCastPanel.this.selectionModel.getSelectedTvShow().saveToDb();
                TvShowCastPanel.this.selectionModel.getSelectedTvShow().writeNFO();
            }
        };
        this.tableActors.setName("tvshows.tvshow.actorTable");
        TmmUILayoutStore.getInstance().install(this.tableActors);
        JScrollPane scrollPaneActors = new JScrollPane(this.tableActors);
        this.tableActors.configureScrollPane(scrollPaneActors);
        this.add((Component)scrollPaneActors, "cell 1 0 1 2,grow");
    }
}

