/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.ExchangeDatasourceDialog;

class TvShowDatasourceSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -675729644848101096L;
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private JCheckBox chckbxDvdOrder;
    private JTextField tfAddBadword;
    private JList<String> listBadWords;
    private JList<String> listDatasources;
    private JPanel panelDatasources;
    private JList<String> listSkipFolder;
    private JPanel panelIgnore;
    private JButton btnAddDatasource;
    private JButton btnRemoveDatasource;
    private JButton btnAddSkipFolder;
    private JButton btnAddSkipRegexp;
    private JButton btnRemoveSkipFolder;
    private JButton btnRemoveBadWord;
    private JButton btnAddBadWord;
    private JButton btnMoveUpDatasoure;
    private JButton btnMoveDownDatasource;
    private JButton btnExchangeDatasource;

    TvShowDatasourceSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddDatasource.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("tvshow.datasource.path");
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.tvshowdatasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addTvShowDataSources(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("tvshow.datasource.path", file.toAbsolutePath().toString());
                this.panelDatasources.revalidate();
            }
        });
        this.btnRemoveDatasource.addActionListener(arg0 -> {
            int row = this.listDatasources.getSelectedIndex();
            if (row != -1) {
                String path = this.settings.getTvShowDataSource().get(row);
                Object[] choices = new String[]{TmmResourceBundle.getString("Button.continue"), TmmResourceBundle.getString("Button.abort")};
                int decision = JOptionPane.showOptionDialog(null, String.format(TmmResourceBundle.getString("Settings.tvshowdatasource.remove.info"), path), TmmResourceBundle.getString("Settings.datasource.remove"), 0, -1, null, choices, TmmResourceBundle.getString("Button.abort"));
                if (decision == 0) {
                    MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                    this.settings.removeTvShowDataSources(path);
                    MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    this.panelDatasources.revalidate();
                }
            }
        });
        this.btnAddSkipFolder.addActionListener(e -> {
            String path = TmmProperties.getInstance().getProperty("tvshow.ignore.path");
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.ignore"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addSkipFolder(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("tvshow.ignore.path", file.toAbsolutePath().toString());
                this.panelIgnore.revalidate();
            }
        });
        this.btnAddSkipRegexp.addActionListener(e -> {
            String regexp = TmmUIHelper.showRegexpInputDialog(SwingUtilities.getWindowAncestor(this));
            if (StringUtils.isNotBlank((CharSequence)regexp)) {
                this.settings.addSkipFolder(regexp);
                this.panelIgnore.revalidate();
            }
        });
        this.btnRemoveSkipFolder.addActionListener(e -> {
            int row = this.listSkipFolder.getSelectedIndex();
            if (row != -1) {
                String ingore = this.settings.getSkipFolder().get(row);
                this.settings.removeSkipFolder(ingore);
                this.panelIgnore.revalidate();
            }
        });
        this.btnAddBadWord.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfAddBadword.getText())) {
                try {
                    Pattern.compile(this.tfAddBadword.getText());
                }
                catch (PatternSyntaxException ex) {
                    JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("message.regex.error"));
                    return;
                }
                TvShowModuleManager.getInstance().getSettings().addBadWord(this.tfAddBadword.getText());
                this.tfAddBadword.setText("");
            }
        });
        this.btnRemoveBadWord.addActionListener(arg0 -> {
            int row = this.listBadWords.getSelectedIndex();
            if (row != -1) {
                String badWord = TvShowModuleManager.getInstance().getSettings().getBadWord().get(row);
                TvShowModuleManager.getInstance().getSettings().removeBadWord(badWord);
            }
        });
        this.btnMoveUpDatasoure.addActionListener(arg0 -> {
            int row = this.listDatasources.getSelectedIndex();
            if (row != -1 && row != 0) {
                this.settings.swapTvShowDataSource(row, row - 1);
                this.listDatasources.setSelectedIndex(--row);
                this.listDatasources.updateUI();
            }
        });
        this.btnMoveDownDatasource.addActionListener(arg0 -> {
            int row = this.listDatasources.getSelectedIndex();
            if (row != -1 && row < this.listDatasources.getModel().getSize() - 1) {
                this.settings.swapTvShowDataSource(row, row + 1);
                this.listDatasources.setSelectedIndex(++row);
                this.listDatasources.updateUI();
            }
        });
        this.btnExchangeDatasource.addActionListener(arg0 -> {
            int row = this.listDatasources.getSelectedIndex();
            if (row != -1) {
                String path = TvShowModuleManager.getInstance().getSettings().getTvShowDataSource().get(row);
                ExchangeDatasourceDialog dialog = new ExchangeDatasourceDialog(path);
                dialog.setVisible(true);
                if (StringUtils.isNotBlank((CharSequence)dialog.getNewDatasource())) {
                    MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                    TvShowModuleManager.getInstance().getSettings().exchangeTvShowDatasource(path, dialog.getNewDatasource());
                    MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    this.panelDatasources.revalidate();
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][][15lp!][]"));
        this.panelDatasources = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp:n][][grow]", "[100lp,grow][][10lp!][]"));
        TmmLabel lblDatasourcesT = new TmmLabel(TmmResourceBundle.getString("Settings.source"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)this.panelDatasources, lblDatasourcesT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#data-sources-1"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        scrollPaneDataSources.setHorizontalScrollBarPolicy(31);
        this.panelDatasources.add((Component)scrollPaneDataSources, "cell 1 0 1 2,grow");
        this.listDatasources = new JList();
        this.listDatasources.setSelectionMode(0);
        scrollPaneDataSources.setViewportView(this.listDatasources);
        this.btnAddDatasource = new SquareIconButton(IconManager.ADD_INV);
        this.panelDatasources.add((Component)this.btnAddDatasource, "flowy, cell 2 0, aligny top, growx");
        this.btnAddDatasource.setToolTipText(TmmResourceBundle.getString("Button.add"));
        this.btnRemoveDatasource = new SquareIconButton(IconManager.REMOVE_INV);
        this.panelDatasources.add((Component)this.btnRemoveDatasource, "flowy, cell 2 0, aligny top, growx");
        this.btnRemoveDatasource.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        this.btnMoveUpDatasoure = new SquareIconButton(IconManager.ARROW_UP_INV);
        this.panelDatasources.add((Component)this.btnMoveUpDatasoure, "flowy, cell 2 0, aligny top, growx");
        this.btnMoveUpDatasoure.setToolTipText(TmmResourceBundle.getString("Button.moveup"));
        this.btnMoveDownDatasource = new SquareIconButton(IconManager.ARROW_DOWN_INV);
        this.panelDatasources.add((Component)this.btnMoveDownDatasource, "flowy, cell 2 0, aligny top, growx");
        this.btnMoveDownDatasource.setToolTipText(TmmResourceBundle.getString("Button.movedown"));
        this.btnExchangeDatasource = new SquareIconButton(IconManager.EXCHANGE);
        this.btnExchangeDatasource.setToolTipText(TmmResourceBundle.getString("Settings.exchangedatasource.desc"));
        this.panelDatasources.add((Component)this.btnExchangeDatasource, "cell 2 1");
        this.chckbxDvdOrder = new JCheckBox(TmmResourceBundle.getString("Settings.dvdorder"));
        this.panelDatasources.add((Component)this.chckbxDvdOrder, "cell 1 3 2 1");
        this.panelIgnore = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp:n][][grow]", "[100lp,grow]"));
        TmmLabel lblIgnoreT = new TmmLabel(TmmResourceBundle.getString("Settings.ignore"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)this.panelIgnore, lblIgnoreT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#exclude-folders-from-scan"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        JScrollPane scrollPaneIgnore = new JScrollPane();
        scrollPaneIgnore.setHorizontalScrollBarPolicy(31);
        this.panelIgnore.add((Component)scrollPaneIgnore, "cell 1 0,grow");
        this.listSkipFolder = new JList();
        scrollPaneIgnore.setViewportView(this.listSkipFolder);
        this.btnAddSkipFolder = new SquareIconButton(IconManager.ADD_INV);
        this.panelIgnore.add((Component)this.btnAddSkipFolder, "flowy, cell 2 0, aligny top, growx");
        this.btnAddSkipFolder.setToolTipText(TmmResourceBundle.getString("Settings.addignore"));
        this.btnAddSkipRegexp = new SquareIconButton(IconManager.FILE_ADD_INV);
        this.panelIgnore.add((Component)this.btnAddSkipRegexp, "flowy, cell 2 0, aligny top, growx");
        this.btnAddSkipRegexp.setToolTipText(TmmResourceBundle.getString("Settings.addignoreregexp"));
        this.btnRemoveSkipFolder = new SquareIconButton(IconManager.REMOVE_INV);
        this.panelIgnore.add((Component)this.btnRemoveSkipFolder, "flowy, cell 2 0, aligny top, growx");
        this.btnRemoveSkipFolder.setToolTipText(TmmResourceBundle.getString("Settings.removeignore"));
        JPanel panelBadWords = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp:n][][grow]", "[][100lp,grow][]"));
        TmmLabel lblBadWordsT = new TmmLabel(TmmResourceBundle.getString("Settings.movie.badwords"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel2 = new CollapsiblePanel((JComponent)panelBadWords, lblBadWordsT, true);
        collapsiblePanel2.addExtraTitleComponent(new DocsButton("/tvshows/settings#bad-words"));
        this.add((Component)collapsiblePanel2, "cell 0 4,growx,wmin 0");
        JLabel lblBadWordsDesc = new JLabel(TmmResourceBundle.getString("Settings.movie.badwords.hint"));
        panelBadWords.add((Component)lblBadWordsDesc, "cell 1 0 3 1");
        JScrollPane scrollPaneBadWords = new JScrollPane();
        scrollPaneBadWords.setHorizontalScrollBarPolicy(31);
        panelBadWords.add((Component)scrollPaneBadWords, "cell 1 1,grow");
        this.listBadWords = new JList();
        scrollPaneBadWords.setViewportView(this.listBadWords);
        this.btnRemoveBadWord = new SquareIconButton(IconManager.REMOVE_INV);
        panelBadWords.add((Component)this.btnRemoveBadWord, "cell 2 1,aligny bottom");
        this.btnRemoveBadWord.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        this.tfAddBadword = new JTextField();
        panelBadWords.add((Component)this.tfAddBadword, "cell 1 2,growx");
        this.btnAddBadWord = new SquareIconButton(IconManager.ADD_INV);
        panelBadWords.add((Component)this.btnAddBadWord, "cell 2 2, growx");
        this.btnAddBadWord.setToolTipText(TmmResourceBundle.getString("Button.add"));
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"dvdOrder");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxDvdOrder, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"tvShowDataSource");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, this.listDatasources);
        jListBinding.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"skipFolder");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, this.listSkipFolder);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"badWord");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listBadWords);
        jListBinding_2.bind();
    }
}

