/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.filenaming.TvShowExtraFanartNaming;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

class TvShowImageSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 4999827736720726395L;
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<ScraperInTable> artworkScrapers = new ArrayList<ScraperInTable>();
    private final ItemListener checkBoxListener = e -> this.checkChanges();
    private TmmTable tableScraper;
    private JTextPane tpScraperDescription;
    private JPanel panelScraperOptions;
    private JCheckBox cbActorImages;
    private JSpinner spDownloadCountExtrafanart;
    private JCheckBox chckbxEnableExtrafanart;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox cbImagePosterSize;
    private JComboBox cbImageFanartSize;
    private JCheckBox chckbxSpecialSeason;
    private JCheckBox chckbxExtraFanart1;
    private JCheckBox chckbxExtraFanart2;
    private JCheckBox chckbxPreferLanguage;

    TvShowImageSettingsPanel() {
        List<String> enabledArtworkProviders = this.settings.getArtworkScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableArtworkScrapers()) {
            ScraperInTable artworkScraper = new ScraperInTable(scraper);
            if (enabledArtworkProviders.contains(artworkScraper.getScraperId())) {
                artworkScraper.setActive(true);
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.artworkScrapers.add(artworkScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 10);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            if (arg0.getColumn() == 0) {
                int row = arg0.getFirstRow();
                ScraperInTable changedScraper = this.artworkScrapers.get(row);
                if (changedScraper.getActive().booleanValue()) {
                    this.settings.addTvShowArtworkScraper(changedScraper.getScraperId());
                } else {
                    this.settings.removeTvShowArtworkScraper(changedScraper.getScraperId());
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.artworkScrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.artworkScrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chckbxExtraFanart1);
        buttonGroup.add(this.chckbxExtraFanart2);
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        this.buildCheckBoxes();
    }

    private void buildCheckBoxes() {
        this.clearSelection(this.chckbxExtraFanart1, this.chckbxExtraFanart2);
        for (TvShowExtraFanartNaming fanart : this.settings.getExtraFanartFilenames()) {
            switch (fanart) {
                case EXTRAFANART: {
                    this.chckbxExtraFanart1.setSelected(true);
                    break;
                }
                case FOLDER_EXTRAFANART: {
                    this.chckbxExtraFanart2.setSelected(true);
                }
            }
        }
        this.chckbxExtraFanart1.addItemListener(this.checkBoxListener);
        this.chckbxExtraFanart2.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.removeItemListener(this.checkBoxListener);
            checkBox.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearExtraFanartFilenames();
        if (this.chckbxExtraFanart1.isSelected()) {
            this.settings.addExtraFanartFilename(TvShowExtraFanartNaming.EXTRAFANART);
        }
        if (this.chckbxExtraFanart2.isSelected()) {
            this.settings.addExtraFanartFilename(TvShowExtraFanartNaming.FOLDER_EXTRAFANART);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][]"));
        TmmLabel lblScraperT = new TmmLabel(TmmResourceBundle.getString("scraper.artwork"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraperT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#artwork-scraper"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ScraperInTable scraper = TvShowImageSettingsPanel.this.artworkScrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        panelScraper.add((Component)panelScraperDetails, "cell 1 2,grow");
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.tpScraperDescription = new ReadOnlyTextPane();
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][15lp!][][][][grow][]"));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options-1"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        JLabel lblScraperLanguage = new JLabel(TmmResourceBundle.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 0 2 1");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.allValuesSorted());
        panelOptions.add(this.cbScraperLanguage, "cell 1 0 2 1");
        JLabel lblImageTmdbPosterSize = new JLabel(TmmResourceBundle.getString("image.poster.size"));
        panelOptions.add((Component)lblImageTmdbPosterSize, "cell 1 1 2 1");
        this.cbImagePosterSize = new JComboBox<MediaArtwork.PosterSizes>(MediaArtwork.PosterSizes.values());
        panelOptions.add((Component)this.cbImagePosterSize, "cell 1 1 2 1");
        JLabel lblImageTmdbFanartSize = new JLabel(TmmResourceBundle.getString("image.fanart.size"));
        panelOptions.add((Component)lblImageTmdbFanartSize, "cell 1 2 2 1");
        this.cbImageFanartSize = new JComboBox<MediaArtwork.FanartSizes>(MediaArtwork.FanartSizes.values());
        panelOptions.add((Component)this.cbImageFanartSize, "cell 1 2 2 1");
        this.chckbxPreferLanguage = new JCheckBox(TmmResourceBundle.getString("Settings.default.autoscrape.language"));
        panelOptions.add((Component)this.chckbxPreferLanguage, "cell 1 3 2 1");
        this.cbActorImages = new JCheckBox(TmmResourceBundle.getString("Settings.actor.download"));
        panelOptions.add((Component)this.cbActorImages, "cell 1 5 2 1");
        this.chckbxSpecialSeason = new JCheckBox(TmmResourceBundle.getString("tvshow.renamer.specialseason"));
        panelOptions.add((Component)this.chckbxSpecialSeason, "cell 1 6 2 1");
        this.chckbxEnableExtrafanart = new JCheckBox(TmmResourceBundle.getString("Settings.enable.extrafanart"));
        panelOptions.add((Component)this.chckbxEnableExtrafanart, "cell 1 7 2 1");
        JPanel panel = new JPanel();
        panelOptions.add((Component)panel, "cell 2 8,growx");
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[][20lp!][]", "[]"));
        this.chckbxExtraFanart1 = new JCheckBox("fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panel.add((Component)this.chckbxExtraFanart1, "cell 0 0");
        this.chckbxExtraFanart2 = new JCheckBox("extrafanart/fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panel.add((Component)this.chckbxExtraFanart2, "cell 2 0");
        JLabel lblDownloadCount = new JLabel(TmmResourceBundle.getString("Settings.amount.autodownload"));
        panelOptions.add((Component)lblDownloadCount, "cell 2 9");
        this.spDownloadCountExtrafanart = new JSpinner();
        this.spDownloadCountExtrafanart.setMinimumSize(new Dimension(60, 20));
        panelOptions.add((Component)this.spDownloadCountExtrafanart, "cell 2 9");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.artworkScrapers, (JTable)this.tableScraper);
        BeanProperty artworkScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty).setColumnName("Aktiv").setColumnClass(Boolean.class);
        BeanProperty artworkScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty artworkScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding_1.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty_1);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"writeActorImages");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.cbActorImages, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"imageExtraFanartCount");
        BeanProperty jSpinnerBeanProperty_1 = BeanProperty.create((String)"value");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty_1);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"imageExtraFanart");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"imageScraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"imagePosterSize");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.cbImagePosterSize, (Property)jComboBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"imageFanartSize");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (Object)this.cbImageFanartSize, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty tvShowSettingsBeanProperty_6 = BeanProperty.create((String)"specialSeason");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_6, (Object)this.chckbxSpecialSeason, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty jCheckBoxBeanProperty_2 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtraFanart1, (Property)jCheckBoxBeanProperty_2);
        autoBinding_9.bind();
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtraFanart2, (Property)jCheckBoxBeanProperty_2);
        autoBinding_10.bind();
        BeanProperty tvShowSettingsBeanProperty_7 = BeanProperty.create((String)"imageLanguagePriority");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_7, (Object)this.chckbxPreferLanguage, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
    }
}

