/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.ScrollingEventDelegator;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.renderer.MultilineTableCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = 5189531235704401313L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenamerSettingsPanel.class);
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<String> spaceReplacements = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private final List<String> colonReplacements = new ArrayList<String>(Arrays.asList(" ", "-", "_"));
    private final EventList<TvShowRenamerExample> exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowRenamerExample.class)));
    private JLabel lblExample;
    private JComboBox<TvShowPreviewContainer> cbTvShowForPreview;
    private EnhancedTextField tfSeasonFolderName;
    private JCheckBox chckbxAsciiReplacement;
    private JCheckBox chckbxShowFoldernameSpaceReplacement;
    private JComboBox cbShowFoldernameSpaceReplacement;
    private JCheckBox chckbxSeasonFoldernameSpaceReplacement;
    private JComboBox cbSeasonFoldernameSpaceReplacement;
    private JCheckBox chckbxFilenameSpaceReplacement;
    private JComboBox cbFilenameSpaceReplacement;
    private JComboBox<TvShowEpisodePreviewContainer> cbEpisodeForPreview;
    private TmmTable tableExamples;
    private EnhancedTextField tfTvShowFolder;
    private EnhancedTextField tfEpisodeFilename;
    private JComboBox cbColonReplacement;
    private JTextField tfFirstCharacter;
    private JCheckBox chckbxAutomaticRename;
    private JCheckBox chckbxCleanupUnwanted;

    public TvShowRenamerSettingsPanel() {
        String colonReplacement;
        this.initComponents();
        this.initDataBindings();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }
        };
        this.tfTvShowFolder.getDocument().addDocumentListener(documentListener);
        this.tfSeasonFolderName.getDocument().addDocumentListener(documentListener);
        this.tfEpisodeFilename.getDocument().addDocumentListener(documentListener);
        this.tfFirstCharacter.getDocument().addDocumentListener(documentListener);
        this.cbTvShowForPreview.addActionListener(arg0 -> {
            this.buildAndInstallEpisodeArray();
            this.createRenamerExample();
        });
        String replacement = this.settings.getRenamerShowPathnameSpaceReplacement();
        int index = this.spaceReplacements.indexOf(replacement);
        if (index >= 0) {
            this.cbShowFoldernameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.spaceReplacements.indexOf(replacement = this.settings.getRenamerSeasonPathnameSpaceReplacement())) >= 0) {
            this.cbSeasonFoldernameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.spaceReplacements.indexOf(replacement = this.settings.getRenamerFilenameSpaceReplacement())) >= 0) {
            this.cbFilenameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.colonReplacements.indexOf(colonReplacement = this.settings.getRenamerColonReplacement())) >= 0) {
            this.cbColonReplacement.setSelectedIndex(index);
        }
        this.lblExample.putClientProperty("clipPosition", 2);
        this.exampleEventList.add((Object)new TvShowRenamerExample("${title}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${originalTitle}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${originalFilename}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${titleSortable}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNr}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNr2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonName}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNrDvd}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNrDvd2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNr}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNr2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNrDvd}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNrDvd2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${airedDate}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeRating}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeImdb}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeTmdb}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeTvdb}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeTags[0]}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${year}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showYear}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showTitle}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showOriginalTitle}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showTitleSortable}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showRating}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showImdb}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showTmdb}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showTvdb}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showStatus}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showTags[0]}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showGenres[0]}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showGenres[0].name}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showGenresAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoResolution}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${aspectRatio}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${aspectRatio2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoCodec}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoBitDepth}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoBitRate}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioCodec}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioCodecList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioCodecsAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannels}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannelList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannelsAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannelsDot}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannelDotList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannelsDotAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioLanguage}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioLanguageList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioLanguagesAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${subtitleLanguageList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${subtitleLanguagesAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${mediaSource}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${hdr}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${hdrformat}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${filesize}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${parent}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showNote}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${note}"));
        ActionListener renamerActionListener = arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        };
        this.chckbxShowFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.chckbxSeasonFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.chckbxFilenameSpaceReplacement.addActionListener(renamerActionListener);
        this.chckbxAsciiReplacement.addActionListener(renamerActionListener);
        this.cbEpisodeForPreview.addActionListener(arg0 -> this.createRenamerExample());
        this.cbShowFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.cbSeasonFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.cbFilenameSpaceReplacement.addActionListener(renamerActionListener);
        this.cbColonReplacement.addActionListener(renamerActionListener);
        this.tableExamples.setPreferredScrollableViewportSize(this.tableExamples.getPreferredSize());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new CopyShortRenamerTokenAction());
        popupMenu.add(new CopyLongRenamerTokenAction());
        this.tableExamples.addMouseListener(new TablePopupListener(popupMenu, this.tableExamples));
        KeyStroke copy = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false);
        this.tableExamples.registerKeyboardAction(new CopyShortRenamerTokenAction(), "Copy", copy, 0);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][][15lp!][]"));
        JPanel panelPatterns = new JPanel((LayoutManager)new MigLayout("insets 0, hidemode 1", "[20lp!][15lp][][300lp,grow]", "[][][][][][][]"));
        TmmLabel lblPatternsT = new TmmLabel(TmmResourceBundle.getString("Settings.tvshow.renamer.title"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelPatterns, lblPatternsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#renamer"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        JLabel lblTvShowFolder = new JLabel(TmmResourceBundle.getString("Settings.tvshowfoldername"));
        panelPatterns.add((Component)lblTvShowFolder, "cell 1 0 2 1,alignx right");
        this.tfTvShowFolder = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfTvShowFolder.setIconToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        this.tfTvShowFolder.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowRenamerSettingsPanel.this.tfTvShowFolder.setText("${showTitle} (${showYear})");
            }
        });
        panelPatterns.add((Component)this.tfTvShowFolder, "cell 3 0 2 1,growx");
        JLabel lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 1 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFolderPattern = new ReadOnlyTextArea("${showTitle} (${showYear})");
        panelPatterns.add((Component)tpDefaultFolderPattern, "cell 3 1 2 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFolderPattern, TmmFontHelper.L2);
        JLabel lblSeasonFolderName = new JLabel(TmmResourceBundle.getString("Settings.tvshowseasonfoldername"));
        panelPatterns.add((Component)lblSeasonFolderName, "cell 1 2 2 1,alignx right");
        this.tfSeasonFolderName = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfSeasonFolderName.setIconToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        this.tfSeasonFolderName.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowRenamerSettingsPanel.this.tfSeasonFolderName.setText("Season ${seasonNr}");
            }
        });
        panelPatterns.add((Component)this.tfSeasonFolderName, "cell 3 2 2 1,growx");
        lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 3 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultSeasonPattern = new ReadOnlyTextArea("Season ${seasonNr}");
        panelPatterns.add((Component)tpDefaultSeasonPattern, "cell 3 3 2 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultSeasonPattern, TmmFontHelper.L2);
        JLabel lblEpisodeFileName = new JLabel(TmmResourceBundle.getString("Settings.tvshowfilename"));
        panelPatterns.add((Component)lblEpisodeFileName, "cell 1 4 2 1,alignx right");
        this.tfEpisodeFilename = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfEpisodeFilename.setIconToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        this.tfEpisodeFilename.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowRenamerSettingsPanel.this.tfEpisodeFilename.setText("${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}");
            }
        });
        panelPatterns.add((Component)this.tfEpisodeFilename, "cell 3 4 2 1,growx");
        lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 5 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFilePattern = new ReadOnlyTextArea("${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}");
        panelPatterns.add((Component)tpDefaultFilePattern, "cell 3 5 2 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFilePattern, TmmFontHelper.L2);
        JLabel lblRenamerHintT = new JLabel(TmmResourceBundle.getString("Settings.tvshow.renamer.hint"));
        panelPatterns.add((Component)lblRenamerHintT, "cell 1 6 3 1");
        JButton btnHelp = new JButton(TmmResourceBundle.getString("tmm.help"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs/tvshows/renamer");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                LOGGER.error("Wiki", (Throwable)e1);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelPatterns.add((Component)btnHelp, "cell 1 6 3 1");
        JPanel panelAdvancedOptions = new JPanel();
        panelAdvancedOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][][]"));
        TmmLabel lblAdvancedOptions = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAdvancedOptions, lblAdvancedOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options-3"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx");
        this.chckbxAutomaticRename = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.automaticrename"));
        panelAdvancedOptions.add((Component)this.chckbxAutomaticRename, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.automaticrename.desc"));
        panelAdvancedOptions.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxShowFoldernameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.showfolderspacereplacement"));
        this.chckbxShowFoldernameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxShowFoldernameSpaceReplacement, "cell 1 1 2 1");
        this.cbShowFoldernameSpaceReplacement = new JComboBox<Object>(this.spaceReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbShowFoldernameSpaceReplacement, "cell 1 1 2 1");
        this.chckbxSeasonFoldernameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.seasonfolderspacereplacement"));
        this.chckbxSeasonFoldernameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxSeasonFoldernameSpaceReplacement, "cell 1 2 2 1");
        this.cbSeasonFoldernameSpaceReplacement = new JComboBox<Object>(this.spaceReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbSeasonFoldernameSpaceReplacement, "cell 1 2 2 1");
        this.chckbxFilenameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.spacereplacement"));
        this.chckbxFilenameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.spacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxFilenameSpaceReplacement, "cell 1 3 2 1");
        this.cbFilenameSpaceReplacement = new JComboBox<Object>(this.spaceReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbFilenameSpaceReplacement, "cell 1 3 2 1");
        JLabel lblColonReplacement = new JLabel(TmmResourceBundle.getString("Settings.renamer.colonreplacement"));
        panelAdvancedOptions.add((Component)lblColonReplacement, "cell 1 4 2 1");
        lblColonReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.colonreplacement.hint"));
        this.cbColonReplacement = new JComboBox<Object>(this.colonReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbColonReplacement, "cell 1 4 2 1");
        this.chckbxAsciiReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.asciireplacement"));
        panelAdvancedOptions.add((Component)this.chckbxAsciiReplacement, "cell 1 5 2 1");
        JLabel lblAsciiHint = new JLabel(TmmResourceBundle.getString("Settings.renamer.asciireplacement.hint"));
        panelAdvancedOptions.add((Component)lblAsciiHint, "cell 2 6");
        TmmFontHelper.changeFont((JComponent)lblAsciiHint, TmmFontHelper.L2);
        this.chckbxCleanupUnwanted = new JCheckBox(TmmResourceBundle.getString("Settings.cleanupfiles"));
        panelAdvancedOptions.add((Component)this.chckbxCleanupUnwanted, "cell 1 7 2 1");
        JLabel lblFirstCharacterT = new JLabel(TmmResourceBundle.getString("Settings.renamer.firstnumbercharacterreplacement"));
        panelAdvancedOptions.add((Component)lblFirstCharacterT, "flowx,cell 1 8 2 1");
        this.tfFirstCharacter = new JTextField();
        panelAdvancedOptions.add((Component)this.tfFirstCharacter, "cell 1 9 2 1");
        this.tfFirstCharacter.setColumns(2);
        JPanel panelExample = new JPanel();
        panelExample.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp,grow]", ""));
        lblAdvancedOptions = new TmmLabel(TmmResourceBundle.getString("Settings.example"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelExample, lblAdvancedOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#example"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx, wmin 0");
        JLabel lblExampleTvShowT = new JLabel(TmmResourceBundle.getString("metatag.tvshow"));
        panelExample.add((Component)lblExampleTvShowT, "cell 1 0");
        this.cbTvShowForPreview = new JComboBox();
        panelExample.add(this.cbTvShowForPreview, "cell 1 0,growx,wmin 0");
        JLabel lblExampleEpisodeT = new JLabel(TmmResourceBundle.getString("metatag.episode"));
        panelExample.add((Component)lblExampleEpisodeT, "cell 1 0");
        this.cbEpisodeForPreview = new JComboBox();
        panelExample.add(this.cbEpisodeForPreview, "cell 1 0,growx,wmin 0");
        this.lblExample = new JLabel("");
        panelExample.add((Component)this.lblExample, "cell 1 1, wmin 0");
        TmmFontHelper.changeFont((JComponent)this.lblExample, 1);
        this.tableExamples = new TmmTable((TableModel)((Object)new TmmTableModel<TvShowRenamerExample>((EventList<TvShowRenamerExample>)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), new TvShowRenamerExampleTableFormat())));
        JScrollPane scrollPane = new JScrollPane();
        this.tableExamples.configureScrollPane(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(21);
        ScrollingEventDelegator.install(scrollPane);
        panelExample.add((Component)scrollPane, "cell 1 2,grow");
        scrollPane.setViewportView(this.tableExamples);
        this.tableExamples.setRowHeight(35);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallTvShowArray();
            this.buildAndInstallEpisodeArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    private void buildAndInstallTvShowArray() {
        this.cbTvShowForPreview.removeAllItems();
        ArrayList<TvShow> allTvShows = new ArrayList<TvShow>(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
        allTvShows.sort(new TvShowComparator());
        TvShow sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShow();
        for (TvShow tvShow : allTvShows) {
            TvShowPreviewContainer container = new TvShowPreviewContainer();
            container.tvShow = tvShow;
            this.cbTvShowForPreview.addItem(container);
            if (sel == null || !tvShow.equals(sel)) continue;
            this.cbTvShowForPreview.setSelectedItem(container);
        }
    }

    private void buildAndInstallEpisodeArray() {
        this.cbEpisodeForPreview.removeAllItems();
        Object obj = this.cbTvShowForPreview.getSelectedItem();
        if (obj instanceof TvShowPreviewContainer) {
            TvShowPreviewContainer c = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
            List<TvShowEpisode> sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
            for (TvShowEpisode episode : c.tvShow.getEpisodes()) {
                TvShowEpisodePreviewContainer container = new TvShowEpisodePreviewContainer();
                container.episode = episode;
                this.cbEpisodeForPreview.addItem(container);
                if (sel == null || sel.size() <= 0 || !episode.equals(sel.get(0))) continue;
                this.cbEpisodeForPreview.setSelectedItem(container);
            }
        }
    }

    private void createRenamerExample() {
        SwingUtilities.invokeLater(() -> {
            Object container;
            TvShow tvShow = null;
            TvShowEpisode episode = null;
            if (this.cbTvShowForPreview.getSelectedItem() instanceof TvShowPreviewContainer) {
                container = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
                tvShow = ((TvShowPreviewContainer)container).tvShow;
            }
            if (this.cbEpisodeForPreview.getSelectedItem() instanceof TvShowEpisodePreviewContainer) {
                container = (TvShowEpisodePreviewContainer)this.cbEpisodeForPreview.getSelectedItem();
                episode = ((TvShowEpisodePreviewContainer)container).episode;
            }
            if (tvShow != null && episode != null) {
                String tvShowDir = TvShowRenamer.getTvShowFoldername(this.tfTvShowFolder.getText(), tvShow);
                MediaFile episodeMf = TvShowRenamer.generateEpisodeFilenames(this.tfEpisodeFilename.getText(), tvShow, episode.getMainVideoFile(), FilenameUtils.getBaseName((String)episode.getMainVideoFile().getFilename())).get(0);
                String newFilenameAndPath = episodeMf.getFile().toString().replace(episode.getTvShow().getPath(), "");
                this.lblExample.setText(tvShowDir + newFilenameAndPath);
                this.lblExample.setToolTipText(tvShowDir + newFilenameAndPath);
                for (TvShowRenamerExample example : this.exampleEventList) {
                    example.createExample(episode);
                }
                TableColumnResizer.adjustColumnPreferredWidths(this.tableExamples, 7);
            } else {
                this.lblExample.setText("");
                this.lblExample.setToolTipText(null);
            }
        });
    }

    private void checkChanges() {
        String spaceReplacement = (String)this.cbShowFoldernameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerShowPathnameSpaceReplacement(spaceReplacement);
        spaceReplacement = (String)this.cbSeasonFoldernameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerSeasonPathnameSpaceReplacement(spaceReplacement);
        spaceReplacement = (String)this.cbFilenameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerFilenameSpaceReplacement(spaceReplacement);
        String colonReplacement = (String)this.cbColonReplacement.getSelectedItem();
        this.settings.setRenamerColonReplacement(colonReplacement);
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"asciiReplacement");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"renamerShowPathnameSpaceSubstitution");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxShowFoldernameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_7 = BeanProperty.create((String)"renamerSeasonPathnameSpaceSubstitution");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_7, (Object)this.chckbxSeasonFoldernameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty_8 = BeanProperty.create((String)"renamerFilenameSpaceSubstitution");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_8, (Object)this.chckbxFilenameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"renamerTvShowFoldername");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.tfTvShowFolder, (Property)jTextFieldBeanProperty_1);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"renamerFilename");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.tfEpisodeFilename, (Property)jTextFieldBeanProperty_2);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"renamerSeasonFoldername");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.tfSeasonFolderName, (Property)jTextFieldBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"renamerFirstCharacterNumberReplacement");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.tfFirstCharacter, (Property)jTextFieldBeanProperty_3);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (Object)this.chckbxAutomaticRename, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSettingsBeanProperty_6 = BeanProperty.create((String)"renamerCleanupUnwanted");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_6, (Object)this.chckbxCleanupUnwanted, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
    }

    private class CopyLongRenamerTokenAction
    extends AbstractAction {
        CopyLongRenamerTokenAction() {
            this.putValue("SwingLargeIconKey", IconManager.COPY);
            this.putValue("SmallIcon", IconManager.COPY);
            this.putValue("Name", TmmResourceBundle.getString("renamer.copytoken.long"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("renamer.copytoken.long"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowRenamerSettingsPanel.this.tableExamples.getSelectedRow();
            if (row > -1) {
                row = TvShowRenamerSettingsPanel.this.tableExamples.convertRowIndexToModel(row);
                TvShowRenamerExample example = (TvShowRenamerExample)TvShowRenamerSettingsPanel.this.exampleEventList.get(row);
                StringSelection stringSelection = new StringSelection(example.longToken);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private class CopyShortRenamerTokenAction
    extends AbstractAction {
        CopyShortRenamerTokenAction() {
            this.putValue("SwingLargeIconKey", IconManager.COPY);
            this.putValue("SmallIcon", IconManager.COPY);
            this.putValue("Name", TmmResourceBundle.getString("renamer.copytoken"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("renamer.copytoken"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowRenamerSettingsPanel.this.tableExamples.getSelectedRow();
            if (row > -1) {
                row = TvShowRenamerSettingsPanel.this.tableExamples.convertRowIndexToModel(row);
                TvShowRenamerExample example = (TvShowRenamerExample)TvShowRenamerSettingsPanel.this.exampleEventList.get(row);
                StringSelection stringSelection = new StringSelection(example.token);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private static class TvShowRenamerExampleTableFormat
    extends TmmTableFormat<TvShowRenamerExample> {
        public TvShowRenamerExampleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token.name"), "name", token -> token.completeToken, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token"), "description", token -> token.description, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "value", token -> token.example, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
        }
    }

    private static class TvShowRenamerExample
    extends AbstractModelObject {
        private static final Pattern TOKEN_PATTERN = Pattern.compile("^\\$\\{(.*?)([\\}\\[;\\.]+.*)");
        private final String token;
        private final String completeToken;
        private String longToken = "";
        private String description;
        private String example = "";

        public TvShowRenamerExample(String token) {
            this.token = token;
            this.completeToken = this.createCompleteToken();
            try {
                this.description = TmmResourceBundle.getString("Settings.tvshow.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        private String createCompleteToken() {
            Object result = this.token;
            Matcher matcher = TOKEN_PATTERN.matcher(this.token);
            if (matcher.find() && matcher.groupCount() > 1) {
                String alias = matcher.group(1);
                String sourceToken = TvShowRenamer.getTokenMap().get(alias);
                if (StringUtils.isNotBlank((CharSequence)sourceToken)) {
                    result = "<html>" + this.token + "<br>${" + sourceToken + matcher.group(2) + "</html>";
                    this.longToken = "${" + sourceToken + matcher.group(2);
                }
            }
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(TvShowEpisode episode) {
            String oldValue = this.example;
            this.example = episode == null ? "" : TvShowRenamer.createDestination(this.token, Collections.singletonList(episode));
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private static class TvShowComparator
    implements Comparator<TvShow> {
        private TvShowComparator() {
        }

        @Override
        public int compare(TvShow arg0, TvShow arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private static class TvShowEpisodePreviewContainer {
        TvShowEpisode episode;

        private TvShowEpisodePreviewContainer() {
        }

        public String toString() {
            return this.episode.getSeason() + "." + this.episode.getEpisode() + " " + this.episode.getTitle();
        }
    }

    private static class TvShowPreviewContainer {
        TvShow tvShow;

        private TvShowPreviewContainer() {
        }

        public String toString() {
            return this.tvShow.getTitle();
        }
    }
}

