/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import java.nio.charset.StandardCharsets;

public class DString {
    public byte[] bytes;

    public DString(byte[] bytes) {
        this.bytes = bytes;
    }

    private String dcharToString(byte[] dchar) {
        if (dchar.length == 1) {
            return new String(dchar, StandardCharsets.UTF_8);
        }
        return new String(dchar, StandardCharsets.UTF_16);
    }

    public String toString() {
        Integer charLen;
        if (this.bytes.length <= 1) {
            return "";
        }
        Integer compressionID = UDFUtil.getUInt8(this.bytes, 0);
        if (compressionID == 8) {
            charLen = 1;
        } else if (compressionID == 16) {
            charLen = 2;
        } else {
            return "Unknown dstring compression ID: " + compressionID.toString();
        }
        byte[] data = UDFUtil.getRemainingBytes(this.bytes, 1);
        String result = "";
        Integer charOffset = 0;
        while (charOffset < data.length) {
            byte[] dcharBytes = UDFUtil.getBytes(data, charOffset, charLen);
            String chr = this.dcharToString(dcharBytes);
            charOffset = charOffset + charLen;
            result = result + chr;
        }
        return result;
    }
}

