/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidExtentAD;

public class ExtentAD {
    public Long length;
    public Long location;
    public static final int LENGTH = 8;

    public ExtentAD(byte[] bytes) throws InvalidExtentAD {
        this.deserialize(bytes);
    }

    private void deserialize(byte[] bytes) throws InvalidExtentAD {
        if (bytes.length < 8) {
            throw new InvalidExtentAD("extent allocation descriptor too short");
        }
        this.length = ExtentAD.calculateLength(bytes, 0);
        this.location = UDFUtil.getUInt32(bytes, 4);
    }

    private static long calculateLength(byte[] src, int offset) {
        long v0 = src[offset] & 0xFF;
        long v1 = src[offset + 1] & 0xFF;
        long v2 = src[offset + 2] & 0xFF;
        long v3 = src[offset + 3] & 0x3F;
        return v3 << 24 | v2 << 16 | v1 << 8 | v0;
    }

    public String toString() {
        return "ExtentAD [length=" + this.length + ", location=" + this.location + "]";
    }
}

