/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import org.codehaus.jackson.JsonNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ApplicationModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;

public final class Application {

    public static class SetVolume
    extends AbstractCall<Integer> {
        public static final String API_TYPE = "Application.SetVolume";

        public SetVolume(Integer n) {
            this.addParameter("volume", n);
        }

        public SetVolume(String string) {
            this.addParameter("volume", string);
        }

        @Override
        protected Integer parseOne(JsonNode jsonNode) {
            return jsonNode.getIntValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetMute
    extends AbstractCall<Boolean> {
        public static final String API_TYPE = "Application.SetMute";

        public SetMute(GlobalModel.Toggle toggle) {
            this.addParameter("mute", (AbstractModel)toggle);
        }

        @Override
        protected Boolean parseOne(JsonNode jsonNode) {
            return jsonNode.getBooleanValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Quit
    extends AbstractCall<String> {
        public static final String API_TYPE = "Application.Quit";

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetProperties
    extends AbstractCall<ApplicationModel.PropertyValue> {
        public static final String API_TYPE = "Application.GetProperties";

        public GetProperties(String ... stringArray) {
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ApplicationModel.PropertyValue parseOne(JsonNode jsonNode) {
            return new ApplicationModel.PropertyValue(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

