/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GUIModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;

public final class GUI {

    public static class ShowNotification
    extends AbstractCall<String> {
        public static final String API_TYPE = "GUI.ShowNotification";

        public ShowNotification(String string, String string2, String string3, Integer n) {
            this.addParameter("title", string);
            this.addParameter("message", string2);
            this.addParameter("image", string3);
            this.addParameter("displaytime", n);
        }

        public ShowNotification(String string, String string2) {
            this.addParameter("title", string);
            this.addParameter("message", string2);
        }

        public ShowNotification(String string, String string2, String string3) {
            this.addParameter("title", string);
            this.addParameter("message", string2);
            this.addParameter("image", string3);
        }

        public ShowNotification(String string, String string2, Integer n) {
            this.addParameter("title", string);
            this.addParameter("message", string2);
            this.addParameter("displaytime", n);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetStereoscopicMode
    extends AbstractCall<String> {
        public static final String API_TYPE = "GUI.SetStereoscopicMode";

        public SetStereoscopicMode(String string) {
            this.addParameter("mode", string);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Mode {
            public static final String TOGGLE = "toggle";
            public static final String TOMONO = "tomono";
            public static final String NEXT = "next";
            public static final String PREVIOUS = "previous";
            public static final String SELECT = "select";
            public static final String OFF = "off";
            public static final String SPLIT_VERTICAL = "split_vertical";
            public static final String SPLIT_HORIZONTAL = "split_horizontal";
            public static final String ROW_INTERLEAVED = "row_interleaved";
            public static final String HARDWARE_BASED = "hardware_based";
            public static final String ANAGLYPH_CYAN_RED = "anaglyph_cyan_red";
            public static final String ANAGLYPH_GREEN_MAGENTA = "anaglyph_green_magenta";
            public static final String MONOSCOPIC = "monoscopic";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("toggle", "tomono", "next", "previous", "select", "off", "split_vertical", "split_horizontal", "row_interleaved", "hardware_based", "anaglyph_cyan_red", "anaglyph_green_magenta", "monoscopic"));
        }
    }

    public static class SetFullscreen
    extends AbstractCall<Boolean> {
        public static final String API_TYPE = "GUI.SetFullscreen";

        public SetFullscreen(GlobalModel.Toggle toggle) {
            this.addParameter("fullscreen", (AbstractModel)toggle);
        }

        @Override
        protected Boolean parseOne(JsonNode jsonNode) {
            return jsonNode.getBooleanValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetStereoscopicModes
    extends AbstractCall<GUIModel.StereoscopyMode> {
        public static final String API_TYPE = "GUI.GetStereoscopicModes";
        public static final String RESULT = "stereoscopicmodes";

        @Override
        protected ArrayList<GUIModel.StereoscopyMode> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<GUIModel.StereoscopyMode> arrayList = new ArrayList<GUIModel.StereoscopyMode>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new GUIModel.StereoscopyMode((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<GUIModel.StereoscopyMode>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetProperties
    extends AbstractCall<GUIModel.PropertyValue> {
        public static final String API_TYPE = "GUI.GetProperties";

        public GetProperties(String ... stringArray) {
            this.addParameter("properties", stringArray);
        }

        @Override
        protected GUIModel.PropertyValue parseOne(JsonNode jsonNode) {
            return new GUIModel.PropertyValue(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class ActivateWindow
    extends AbstractCall<String> {
        public static final String API_TYPE = "GUI.ActivateWindow";

        public ActivateWindow(String string, String ... stringArray) {
            this.addParameter("window", string);
            this.addParameter("parameters", stringArray);
        }

        public ActivateWindow(String string) {
            this.addParameter("window", string);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

