/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.PVRModel;

public final class PVR {

    public static class Scan
    extends AbstractCall<String> {
        public static final String API_TYPE = "PVR.Scan";

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Record
    extends AbstractCall<String> {
        public static final String API_TYPE = "PVR.Record";

        public Record(GlobalModel.Toggle toggle, String string) {
            this.addParameter("record", (AbstractModel)toggle);
            this.addParameter("channel", string);
        }

        public Record(GlobalModel.Toggle toggle, Integer n) {
            this.addParameter("record", (AbstractModel)toggle);
            this.addParameter("channel", n);
        }

        public Record() {
        }

        public Record(GlobalModel.Toggle toggle) {
            this.addParameter("record", (AbstractModel)toggle);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Channel {
            public static final String CURRENT = "current";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("current"));
        }
    }

    public static class GetTimers
    extends AbstractCall<PVRModel.TimerDetail> {
        public static final String API_TYPE = "PVR.GetTimers";
        public static final String RESULT = "timers";

        public GetTimers(ListModel.Limits limits, String ... stringArray) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<PVRModel.TimerDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<PVRModel.TimerDetail> arrayList = new ArrayList<PVRModel.TimerDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new PVRModel.TimerDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<PVRModel.TimerDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetTimerDetails
    extends AbstractCall<PVRModel.TimerDetail> {
        public static final String API_TYPE = "PVR.GetTimerDetails";
        public static final String RESULT = "timerdetails";

        public GetTimerDetails(Integer n, String ... stringArray) {
            this.addParameter("timerid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected PVRModel.TimerDetail parseOne(JsonNode jsonNode) {
            return new PVRModel.TimerDetail((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetRecordings
    extends AbstractCall<PVRModel.RecordingDetail> {
        public static final String API_TYPE = "PVR.GetRecordings";
        public static final String RESULT = "recordings";

        public GetRecordings(ListModel.Limits limits, String ... stringArray) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<PVRModel.RecordingDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<PVRModel.RecordingDetail> arrayList = new ArrayList<PVRModel.RecordingDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new PVRModel.RecordingDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<PVRModel.RecordingDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecordingDetails
    extends AbstractCall<PVRModel.RecordingDetail> {
        public static final String API_TYPE = "PVR.GetRecordingDetails";
        public static final String RESULT = "recordingdetails";

        public GetRecordingDetails(Integer n, String ... stringArray) {
            this.addParameter("recordingid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected PVRModel.RecordingDetail parseOne(JsonNode jsonNode) {
            return new PVRModel.RecordingDetail((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetProperties
    extends AbstractCall<PVRModel.PropertyValue> {
        public static final String API_TYPE = "PVR.GetProperties";

        public GetProperties(String ... stringArray) {
            this.addParameter("properties", stringArray);
        }

        @Override
        protected PVRModel.PropertyValue parseOne(JsonNode jsonNode) {
            return new PVRModel.PropertyValue(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetChannels
    extends AbstractCall<PVRModel.ChannelDetail> {
        public static final String API_TYPE = "PVR.GetChannels";
        public static final String RESULT = "channels";

        public GetChannels(PVRModel.ChannelGroupId channelGroupId, ListModel.Limits limits, String ... stringArray) {
            this.addParameter("channelgroupid", (AbstractModel)channelGroupId);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        public GetChannels(PVRModel.ChannelGroupId channelGroupId, String ... stringArray) {
            this.addParameter("channelgroupid", (AbstractModel)channelGroupId);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<PVRModel.ChannelDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<PVRModel.ChannelDetail> arrayList = new ArrayList<PVRModel.ChannelDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new PVRModel.ChannelDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<PVRModel.ChannelDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetChannelGroups
    extends AbstractCall<PVRModel.ChannelGroupDetail> {
        public static final String API_TYPE = "PVR.GetChannelGroups";
        public static final String RESULT = "channelgroups";

        public GetChannelGroups(String string, ListModel.Limits limits) {
            this.addParameter("channeltype", string);
            this.addParameter("limits", (AbstractModel)limits);
        }

        public GetChannelGroups(String string) {
            this.addParameter("channeltype", string);
        }

        @Override
        protected ArrayList<PVRModel.ChannelGroupDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<PVRModel.ChannelGroupDetail> arrayList = new ArrayList<PVRModel.ChannelGroupDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new PVRModel.ChannelGroupDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<PVRModel.ChannelGroupDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetChannelGroupDetails
    extends AbstractCall<PVRModel.ChannelGroupExtendedDetail> {
        public static final String API_TYPE = "PVR.GetChannelGroupDetails";
        public static final String RESULT = "channelgroupdetails";

        public GetChannelGroupDetails(PVRModel.ChannelGroupId channelGroupId, Channel channel) {
            this.addParameter("channelgroupid", (AbstractModel)channelGroupId);
            this.addParameter("channels", (AbstractModel)channel);
        }

        public GetChannelGroupDetails(PVRModel.ChannelGroupId channelGroupId) {
            this.addParameter("channelgroupid", (AbstractModel)channelGroupId);
        }

        @Override
        protected PVRModel.ChannelGroupExtendedDetail parseOne(JsonNode jsonNode) {
            return new PVRModel.ChannelGroupExtendedDetail((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class Channel
        extends AbstractModel {
            public static final String LIMITS = "limits";
            public static final String PROPERTIES = "properties";
            public final ListModel.Limits limits;
            public final String properties;

            public Channel(ListModel.Limits limits, String string) {
                this.limits = limits;
                this.properties = string;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(LIMITS, this.limits == null ? null : this.limits.toJsonNode());
                objectNode.put(PROPERTIES, this.properties);
                return objectNode;
            }

            public static interface Property {
                public static final String THUMBNAIL = "thumbnail";
                public static final String CHANNELTYPE = "channeltype";
                public static final String HIDDEN = "hidden";
                public static final String LOCKED = "locked";
                public static final String CHANNEL = "channel";
                public static final String LASTPLAYED = "lastplayed";
                public static final String BROADCASTNOW = "broadcastnow";
                public static final String BROADCASTNEXT = "broadcastnext";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("thumbnail", "channeltype", "hidden", "locked", "channel", "lastplayed", "broadcastnow", "broadcastnext"));
            }
        }
    }

    public static class GetChannelDetails
    extends AbstractCall<PVRModel.ChannelDetail> {
        public static final String API_TYPE = "PVR.GetChannelDetails";
        public static final String RESULT = "channeldetails";

        public GetChannelDetails(Integer n, String ... stringArray) {
            this.addParameter("channelid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected PVRModel.ChannelDetail parseOne(JsonNode jsonNode) {
            return new PVRModel.ChannelDetail((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetBroadcasts
    extends AbstractCall<PVRModel.BroadcastDetail> {
        public static final String API_TYPE = "PVR.GetBroadcasts";
        public static final String RESULT = "broadcasts";

        public GetBroadcasts(Integer n, ListModel.Limits limits, String ... stringArray) {
            this.addParameter("channelid", n);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        public GetBroadcasts(Integer n, String ... stringArray) {
            this.addParameter("channelid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<PVRModel.BroadcastDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<PVRModel.BroadcastDetail> arrayList = new ArrayList<PVRModel.BroadcastDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new PVRModel.BroadcastDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<PVRModel.BroadcastDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetBroadcastDetails
    extends AbstractCall<PVRModel.BroadcastDetail> {
        public static final String API_TYPE = "PVR.GetBroadcastDetails";
        public static final String RESULT = "broadcastdetails";

        public GetBroadcastDetails(Integer n, String ... stringArray) {
            this.addParameter("broadcastid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected PVRModel.BroadcastDetail parseOne(JsonNode jsonNode) {
            return new PVRModel.BroadcastDetail((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

